@extends('layouts.app')
@section('title', $page_title)

<!-- Professional Image Manager Card Styles -->
@section('styles')
<style>
/* Professional Image Manager Card Styling */
.builder-card-container {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border-radius: 20px;
    box-shadow: 0 12px 40px rgba(0, 0, 0, 0.12);
    border: 1px solid #dee2e6;
    overflow: hidden;
    position: relative;
    margin: 20px;
    transition: all 0.4s ease;
}

.builder-card-container::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 6px;
    background: linear-gradient(90deg, #667eea 0%, #764ba2 50%, #f093fb 100%);
    z-index: 10;
}

.builder-card-container:hover {
    box-shadow: 0 16px 50px rgba(0, 0, 0, 0.18);
}

/* Card Header */
.builder-card-header {
    background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
    padding: 1.5rem 2rem;
    border-bottom: 1px solid #e9ecef;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    position: relative;
    z-index: 5;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.builder-card-title-section {
    flex: 1;
    display: flex;
    align-items: center;
    gap: 1rem;
    flex-wrap: wrap;
}

.builder-card-title {
    font-size: 1.5rem;
    font-weight: 700;
    color: #2c3e50;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.builder-card-title::before {
    content: '🎨';
    font-size: 1.8rem;
}

.builder-card-actions {
    display: flex;
    gap: 1rem;
    align-items: center;
    flex-wrap: wrap;
    justify-content: flex-start;
}

.builder-card-title-section .btn {
    margin: 0;
}

.shortcode-section {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    flex-wrap: wrap;
}

.shortcode-help {
    color: #6c757d;
    font-size: 0.8rem;
    line-height: 1.4;
    margin: 0;
}

.builder-card-subtitle {
    color: #6c757d;
    font-size: 0.95rem;
    margin: 0.5rem 0 0 0;
    font-weight: 400;
}

.builder-card-actions {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-top: 1rem;
}

.builder-card-actions .btn {
    border-radius: 8px;
    font-weight: 600;
    padding: 0.5rem 1.25rem;
    transition: all 0.3s ease;
    border: none;
    text-decoration: none;
}

.builder-card-actions .btn-outline-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: 2px solid transparent;
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
}

.builder-card-actions .btn-outline-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 16px rgba(102, 126, 234, 0.4);
    color: white;
}

.builder-card-actions .btn-outline-primary:focus {
    box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
    color: white;
}

/* Card Body */
.builder-card-body {
    background: white;
    padding: 0;
    position: relative;
    min-height: 600px;
}

.builder-iframe-container {
    position: relative;
    width: 100%;
    height: 820px;
    border-radius: 0 0 20px 20px;
    overflow: hidden;
    box-shadow: inset 0 2px 8px rgba(0, 0, 0, 0.06);
}

.builder-iframe-container iframe {
    width: 100%;
    height: 100%;
    border: none;
    border-radius: 0 0 20px 20px;
    background: #ffffff;
}

/* Loading State */
.builder-loading {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    text-align: center;
    z-index: 15;
    background: rgba(255, 255, 255, 0.95);
    padding: 2rem;
    border-radius: 12px;
    box-shadow: 0 8px 24px rgba(0, 0, 0, 0.1);
}

.builder-loading .spinner-border {
    width: 3rem;
    height: 3rem;
    border-width: 0.3em;
    color: #667eea;
}

.builder-loading p {
    margin-top: 1rem;
    color: #6c757d;
    font-weight: 500;
}

/* Status Indicator */
.builder-status {
    position: absolute;
    top: 1rem;
    right: 1rem;
    background: rgba(40, 167, 69, 0.1);
    color: #28a745;
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-size: 0.8rem;
    font-weight: 600;
    border: 1px solid rgba(40, 167, 69, 0.2);
    z-index: 12;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.builder-status::before {
    content: '●';
    font-size: 0.6rem;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Responsive Design */
@media (max-width: 768px) {
    .builder-card-container {
        margin: 10px;
        border-radius: 16px;
    }
    
    .builder-card-header {
        padding: 1rem 1.5rem;
        flex-direction: column;
        gap: 1rem;
        text-align: center;
    }
    
    .builder-card-title-section {
        flex-direction: column;
        align-items: flex-start;
        gap: 0.75rem;
        width: 100%;
    }
    
    .shortcode-section {
        flex-direction: column;
        align-items: flex-start;
        gap: 0.5rem;
        width: 100%;
    }
    
    .builder-card-title {
        font-size: 1.25rem;
    }
    
    .builder-card-actions {
        flex-direction: column;
        align-items: stretch;
        gap: 0.75rem;
    }
    
    .builder-iframe-container {
        height: 600px;
    }
}

/* Professional Animations */
.builder-card-container {
    animation: cardSlideIn 0.8s ease-out;
}

@keyframes cardSlideIn {
    from {
        opacity: 0;
        transform: translateY(30px) scale(0.95);
    }
    to {
        opacity: 1;
        transform: translateY(0) scale(1);
    }
}

.builder-card-actions .btn {
    will-change: transform;
}

.builder-card-actions .btn:hover {
    will-change: transform;
}
</style>
@endsection

@section('scripts')
<script>
$(function () {
  'use strict';
  
  // Professional card initialization
  const $card = $('.builder-card-container');
  const $iframe = $('.builder-iframe-container iframe');
  const $loading = $('.builder-loading');
  const $status = $('.builder-status');
  
  // Show loading state
  $loading.show();
  $status.text('Initializing Builder...');
  
  // Hide loading when iframe loads
  $iframe.on('load', function() {
    setTimeout(function() {
      $loading.fadeOut(300);
      $status.text('Builder Ready');
      $card.addClass('card-loaded');
    }, 1000);
  });
  
  // Professional hover effects
  $card.hover(
    function() {
      $(this).addClass('card-hover');
    },
    function() {
      $(this).removeClass('card-hover');
    }
  );
  
  // Button click animations
  $('.builder-card-actions .btn').on('click', function() {
    $(this).addClass('btn-clicked');
    setTimeout(() => {
      $(this).removeClass('btn-clicked');
    }, 200);
  });
  
  // Modal handling
  $(".modal").on("hidden.bs.modal", function() {
    document.getElementById("shortcode").select();
    document.execCommand("copy");
    $('.btn-primary').focus();
  });
  
  // Status updates
  function updateStatus(message, type = 'success') {
    $status.removeClass('status-success status-warning status-error')
           .addClass('status-' + type)
           .text(message);
  }
  
  // Error handling
  $iframe.on('error', function() {
    updateStatus('Builder Error', 'error');
    $loading.find('p').text('Failed to load builder. Please refresh the page.');
  });
});

// Professional CSS for animations
$('<style>')
    .prop('type', 'text/css')
    .html(`
        .card-loaded {
            animation: cardLoaded 0.6s ease-out;
        }
        
        @keyframes cardLoaded {
            from {
                transform: translateY(0) scale(1);
            }
            to {
                transform: translateY(-6px) scale(1.02);
            }
        }
        
        .card-hover {
            animation: cardHover 0.3s ease-out;
        }
        
        @keyframes cardHover {
            from {
                transform: translateY(0);
            }
            to {
                transform: translateY(-6px);
            }
        }
        
        .btn-clicked {
            animation: btnClick 0.2s ease-out;
        }
        
        @keyframes btnClick {
            0% { transform: scale(1); }
            50% { transform: scale(0.95); }
            100% { transform: scale(1); }
        }
        
        .status-success {
            background: rgba(40, 167, 69, 0.1);
            color: #28a745;
            border-color: rgba(40, 167, 69, 0.2);
        }
        
        .status-warning {
            background: rgba(255, 193, 7, 0.1);
            color: #ffc107;
            border-color: rgba(255, 193, 7, 0.2);
        }
        
        .status-error {
            background: rgba(220, 53, 69, 0.1);
            color: #dc3545;
            border-color: rgba(220, 53, 69, 0.2);
        }
    `)
    .appendTo('head');
</script>
@endsection
@section('content')
<!-- Professional Image Manager Card -->
<div class="builder-card-container">
    <!-- Card Header -->
    <div class="builder-card-header">
        <div class="builder-card-title-section">
            <h2 class="builder-card-title">{{ __('app.email_builder') }}</h2>
            <div class="shortcode-section">
                <button type="button" 
                        class="btn btn-outline-primary btn-sm" 
                        onclick="viewModal('modal', '{{ route('shortcodes') }}');">
                    <i class="bi bi-code-slash me-2"></i>
                    {{ __('app.shortcodes') }}
                </button>
                <small class="text-info">
                    {!! __('app.shortcode_help_template') !!}
                </small>
            </div>
        </div>
    </div>
    
    <!-- Card Body -->
    <div class="builder-card-body">
        <!-- Status Indicator -->
       
        <!-- Loading State -->
        <div class="builder-loading" style="display: none;">
            <div class="spinner-border" role="status">
                <span class="visually-hidden">{{ __('app.loading') }}...</span>
            </div>
            <p>{{ __('app.initializing_builder') }}...</p>
        </div>
        
        <!-- Builder Iframe Container -->
        <div class="builder-iframe-container">
            <iframe src="/get_rz_builder?id={{$id ?? 0}}&action={{$action ?? 'create'}}" 
                    frameborder="0" 
                    scrolling="yes" 
                    allowfullscreen>
            </iframe>
        </div>
    </div>
</div>
@endsection
