<script src="{{asset('assets/js/app.js')}}"></script>
<style>
/* Override any conflicting CSS from schedule.css or smart_wizard CSS */
.modal-dialog {
  max-width: 600px !important;
  width: 90% !important;
  margin: 1.75rem auto !important;
}

.modal-content {
  border-radius: 0.5rem !important;
  box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;
}

.modal-body {
  max-height: 70vh !important;
  overflow-y: auto !important;
  padding: 1.5rem !important;
  scrollbar-width: thin !important;
  scrollbar-color: #888 #f0f0f0 !important;
}

/* Professional editor selection cards */
.editor-card {
  border: 1px solid var(--bs-border-color) !important;
  border-radius: 0.5rem !important;
  padding: 1.5rem !important;
  text-align: center !important;
  transition: all 0.3s ease !important;
  background: var(--bs-body-bg) !important;
  height: 100% !important;
  display: flex !important;
  flex-direction: column !important;
  justify-content: center !important;
}

.editor-card:hover {
  border-color: var(--bs-primary) !important;
  box-shadow: 0 0.25rem 0.5rem rgba(var(--bs-primary-rgb), 0.15) !important;
  transform: translateY(-2px) !important;
}

.editor-card img {
  max-width: 120px !important;
  height: auto !important;
  margin: 0 auto 1rem auto !important;
  border-radius: 0.375rem !important;
  display: block !important;
}

.editor-card .btn {
  border-radius: 0.375rem !important;
  font-weight: 600 !important;
  padding: 0.75rem 1.5rem !important;
  transition: all 0.15s ease-in-out !important;
}

.editor-card .btn:hover {
  transform: translateY(-1px) !important;
  box-shadow: 0 0.25rem 0.5rem rgba(var(--bs-primary-rgb), 0.25) !important;
}
</style>

<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
  <div class="modal-content">
    @csrf
    <div class="modal-header">
      <div class="d-flex align-items-center">
        <div class="p-2 border border-primary border-opacity-10 bg-primary-transparent rounded-circle me-3">
          <span class="avatar avatar-sm avatar-rounded bg-primary svg-white">
            <i class="bi bi-file-earmark-code"></i>
          </span>
        </div>
        <h6 class="modal-title mb-0 fw-semibold">{{__('app.select_editor')}}</h6>
      </div>
      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{__('app.close')}}"></button>
    </div>
    
    <div class="modal-body">
      <div class="row g-4">
        <!-- Advanced Editor -->
        <div class="col-md-6">
          <div class="editor-card">
            <img src="{{asset('assets/images/relayzo/editor_advance.png')}}" alt="{{__('app.advance_editor')}}" class="img-fluid">
            <h6 class="fw-semibold mb-3">{{__('app.advance_editor')}}</h6>
            <p class=" mb-3 small">{{__('app.advance_editor_description')}}</p>
            <a href="{{route('templates.create', 'editor=2')}}" class="btn btn-primary">
              <i class="bi bi-code-slash me-2"></i>{{__('app.advance_editor')}}
            </a>
          </div>
        </div>
        
        <!-- Simple Editor -->
        <div class="col-md-6">
          <div class="editor-card">
            <img src="{{asset('assets/images/relayzo/editor_simple.png')}}" alt="{{__('app.simple_editor')}}" class="img-fluid">
            <h6 class="fw-semibold mb-3">{{__('app.simple_editor')}}</h6>
            <p class=" mb-3 small">{{__('app.simple_editor_description')}}</p>
            <a href="{{route('templates.create', 'editor=1')}}" class="btn btn-primary">
              <i class="bi bi-pencil-square me-2"></i>{{__('app.simple_editor')}}
            </a>
          </div>
        </div>
      </div>
    </div>
    
    <div class="modal-footer">
      <button type="button" class="btn btn-light" data-bs-dismiss="modal">
        <i class="bi bi-arrow-left me-1"></i>{{__('app.close')}}
      </button>
    </div>
  </div>
</div>
