<script src="{{asset('assets/js/app.js')}}"></script>
<script src="{{asset('assets/js/update.js')}}"></script>
<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
	<div class="modal-content">
		<form>
			<!-- Modal Header -->
			<div class="modal-header bg-primary text-white">
				<div class="d-flex align-items-center">
					<div class="p-2 border border-white border-opacity-25 bg-white bg-opacity-10 rounded-circle me-3">
						<span class="avatar avatar-xs avatar-rounded bg-white text-primary">
							<i class="bi bi-arrow-up-circle"></i>
						</span>
					</div>
					<div>
						<h6 class="modal-title mb-0 fw-semibold">{{__('app.update')}}</h6>
						<small class="opacity-75">{{__('app.update_description')}}</small>
					</div>
				</div>
				<button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="{{__('app.close')}}"></button>
			</div>
			
			<!-- Modal Body -->
			<div class="modal-body p-4">
				<div class="row">
					<div class="col-12">
						<div class="d-flex align-items-center mb-3">
							<h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.version_information')}}</h6>
						</div>
					</div>
				</div>
				
				<div class="row mb-3">
					<div class="col-md-4">
						<label class="form-label fw-semibold">{{__('app.license_key')}}:</label>
					</div>
					<div class="col-md-8">
						<code class="bg-light p-2 rounded d-block">{{ $settings->license_key }}</code>
					</div>
				</div>
				
				<div class="row mb-3">
					<div class="col-md-4">
						<label class="form-label fw-semibold">{{__('app.application_version')}}:</label>
					</div>
					<div class="col-md-8">
						<span class="badge bg-secondary">{{ $settings->current_version }}</span>
					</div>
				</div>
				
				<div class="row mb-3">
					<div class="col-md-4">
						<label class="form-label fw-semibold">{{__('app.available_version')}}:</label>
					</div>
					<div class="col-md-8">
						<span class="badge bg-primary">{{ $settings->available_version }}</span>
					</div>
				</div>
				
				@if($settings->available_version > $settings->current_version)
				<div class="alert alert-warning d-flex align-items-center mb-3">
					<i class="bi bi-exclamation-triangle me-2"></i>
					<div>
						<strong>{{__('app.update_available')}}</strong>
						<div class="small">{{__('app.latest_version_msg')}}</div>
					</div>
				</div>
				@else
				<div class="alert alert-success d-flex align-items-center mb-3">
					<i class="bi bi-check-circle me-2"></i>
					<div>
						<strong>{{__('app.up_to_date')}}</strong>
						<div class="small">{{__('app.already_latest_version_msg')}}</div>
					</div>
				</div>
				@endif
				
				<div class="row">
					<div class="col-12">
						<div class="d-flex justify-content-center">
							<a href="https://relayzo.com/change-log" target="_blank" class="btn btn-outline-primary btn-sm d-flex align-items-center">
								<i class="bi bi-box-arrow-up-right me-2"></i>
								{{__('app.view_change_log')}}
							</a>
						</div>
					</div>
				</div>
			</div>
			
			<!-- Modal Footer -->
			<div class="modal-footer bg-light">
				<span id="msg" class="me-auto"></span>
				<button type="button" class="btn btn-light" data-bs-dismiss="modal">
					<i class="bi bi-x-circle me-1"></i>{{__('app.close')}}
				</button>
				@if($settings->available_version > $settings->current_version)
				<button type="button" id="btn-update" class="btn btn-primary btn-loading" data-route="{{ route('update.app') }}">
					<i class="bi bi-arrow-up-circle me-1"></i>{{__('app.update')}}
				</button>
				@endif
			</div>
		</form>
	</div>
</div>
<span id="update-proceed-msg" data-value="{{ __('app.update_proceed_msg') }}"></span>
<span id="update-warning-msg" data-value="{{ __('app.update_warning_msg') }}"></span>
