<script>
$('[data-bs-toggle="popover"]').popover({
    container: 'body'
});

$(document).on('click', '.bi-copy', function() {
    // Find the nearest input field within the same input group
    var inputVal = $(this).closest('.input-group').find('input').val();
    
    // Use modern Clipboard API if available, fallback to execCommand
    if (navigator.clipboard && window.isSecureContext) {
        navigator.clipboard.writeText(inputVal).then(function() {
            toastr.success('Copied successfully!');
        }).catch(function(err) {
            console.error('Failed to copy: ', err);
            fallbackCopyTextToClipboard(inputVal);
        });
    } else {
        fallbackCopyTextToClipboard(inputVal);
    }
});

function fallbackCopyTextToClipboard(text) {
    // Create a temporary textarea element
    var textArea = document.createElement("textarea");
    textArea.value = text;
    
    // Avoid scrolling to bottom
    textArea.style.top = "0";
    textArea.style.left = "0";
    textArea.style.position = "fixed";
    textArea.style.opacity = "0";
    
    document.body.appendChild(textArea);
    textArea.focus();
    textArea.select();
    
    try {
        var successful = document.execCommand('copy');
        if (successful) {
            toastr.success('Copied successfully!');
        } else {
            toastr.error('Failed to copy text');
        }
    } catch (err) {
        console.error('Fallback: Oops, unable to copy', err);
        toastr.error('Failed to copy text');
    }
    
    document.body.removeChild(textArea);
}
</script>
<script src="{{asset('assets/js/app.js')}}"></script>
<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
    <div class="modal-content">
      <form id="frm-group" method="post" action="{{route('tracking_domains.update', $tracking_domain->id)}}" class="needs-validation" novalidate>
        @csrf
        @method('PUT')
        <div class="modal-header">
          <div class="d-flex align-items-center">
            <div class="me-3">
              <span class="avatar avatar-sm avatar-rounded bg-info svg-white">
                <i class="bi bi-pencil-square"></i>
              </span>
            </div>
            <h6 class="modal-title mb-0 fw-semibold">{{__('app.edit_tracking_domain')}}</h6>
          </div>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{__('app.close')}}"></button>
        </div>
        <div class="modal-body">
          <div class="box-body">
            <!-- Domain Configuration Section -->
            <div class="row mb-3">
              <div class="col-md-3">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.protocol')}}</label>
                  <select name="protocol" class="form-select form-select-lg">
                     <option value="https://" {{ $tracking_domain->protocol == 'https://' ? 'selected' : '' }}>https://</option>
                     <option value="http://" {{ $tracking_domain->protocol == 'http://' ? 'selected' : '' }}>http://</option>
                  </select>
                </div>
              </div>
              <div class="col-md-9">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.domain')}}</label>
                  <input type="text" class="form-control" placeholder="{{__('app.domain')}}" value="{{$tracking_domain->domain}}" name="domain" required>
                  <div class="invalid-feedback">{{__('app.domain_required')}}</div>
                </div>
              </div>
            </div>

            <!-- Settings Section -->
            <div class="row mb-3">
              <div class="col-12">
                <div class="d-flex align-items-center">
                  <div class="me-3">
                    <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                      <i class="bi bi-gear"></i>
                    </span>
                  </div>
                  <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.settings')}}</h6>
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label class="form-label fw-semibold mt-3">{{__('app.active')}}</label>
                  <select name="is_active" class="form-select form-select-lg">
                     <option value="1" {{ $tracking_domain->is_active ? 'selected' : '' }}>{{ __('app.yes')}}</option>
                     <option value="0" {{ $tracking_domain->is_active ? '' : 'selected' }}>{{ __('app.no') }}</option>
                  </select>
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label class="form-label fw-semibold mt-3">{{__('app.verified')}}
                    <a tabindex="-1" role="button"
                    data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.verified')}}"
                    data-bs-content="{{__('app.domain_verified_help')}}" data-bs-custom-class="header-primary" class="text-primary ms-1">
                      <i class="bi bi-question-circle"></i>
                    </a>
                  </label>
                  <select name="is_verified" class="form-select form-select-lg">
                     <option value="0" {{ $tracking_domain->is_verified ? '' : 'selected' }}>{{ __('app.no')}}</option>
                     <option value="1" {{ $tracking_domain->is_verified ? 'selected' : '' }}>{{ __('app.yes') }}</option>
                  </select>
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label class="form-label fw-semibold mt-3">{{__('app.auto_verification')}}
                    <a tabindex="-1" role="button"
                    data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.auto_verification')}}"
                    data-bs-content="{{__('app.domain_auto_verfication_help')}}" data-bs-custom-class="header-primary" class="text-primary ms-1">
                      <i class="bi bi-question-circle"></i>
                    </a>
                  </label>
                  <select name="auto_verification" class="form-select form-select-lg">
                     <option value="0" {{ $tracking_domain->auto_verification ? '' : 'selected' }}>{{ __('app.no')}}</option>
                     <option value="1" {{ $tracking_domain->auto_verification ? 'selected' : '' }}>{{ __('app.yes') }}</option>
                  </select>
                </div>
              </div>
            </div>

            <!-- DNS Entry Section -->
            <div class="row mb-3">
              <div class="col-12">
                <div class="d-flex align-items-center">
                  <div class="me-3">
                    <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                      <i class="bi bi-server"></i>
                    </span>
                  </div>
                  <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.dns_entry')}}</h6>
                </div>
              </div>
              <div class="col-12">
                <div class="alert alert-light">
                  {!! str_replace('[domain-name]', $tracking_domain->domain , __('app.help_dns_entries_trackging_domains')) !!}
                </div>
              </div>
            </div>

            <!-- DNS Records Table -->
            <div class="row mb-3">
              <div class="col-12">
                <div class="table-responsive">
                  <table class="table table-bordered table-sm">
                    <thead class="table-light">
                      <tr>
                        <th class="fw-semibold py-2">{{__('app.type')}}</th>
                        <th class="fw-semibold py-2">{{__('app.host')}}</th>
                        <th class="fw-semibold py-2">{{__('app.value')}}</th>
                      </tr>
                    </thead>
                    <tbody>
                      <!-- TXT Record -->
                      <tr>
                        <td class="py-2"><span class="badge bg-primary">TXT</span></td>
                        <td class="py-2">
                          <div class="input-group input-group-sm">
                            <input type="text" class="form-control form-control-sm" value="{{$tracking_domain->domain}}" readonly>
                            <button class="btn btn-outline-secondary btn-sm" type="button">
                              <i class="bi bi-copy"></i>
                            </button>
                          </div>
                        </td>
                        <td class="py-2">
                          <div class="input-group input-group-sm">
                            <input type="text" class="form-control form-control-sm" value="{{\App\Http\Helper\Helper::getAppURL(true)}}" readonly>
                            <button class="btn btn-outline-secondary btn-sm" type="button">
                              <i class="bi bi-copy"></i>
                            </button>
                          </div>
                        </td>
                      </tr>
                      <!-- OR Divider -->
                      <tr class="table-light">
                        <td colspan="3" class="text-center fw-bold text-success py-1">OR</td>
                      </tr>
                      <!-- A Record -->
                      <tr>
                        <td class="py-2"><span class="badge bg-info">A</span></td>
                        <td class="py-2">
                          <div class="input-group input-group-sm">
                            <input type="text" class="form-control form-control-sm" value="{{$tracking_domain->domain}}" readonly>
                            <button class="btn btn-outline-secondary btn-sm" type="button">
                              <i class="bi bi-copy"></i>
                            </button>
                          </div>
                        </td>
                        <td class="py-2">
                          <div class="input-group input-group-sm">
                            <input type="text" class="form-control form-control-sm" value="{{$_SERVER['SERVER_ADDR']}}" readonly>
                            <button class="btn btn-outline-secondary btn-sm" type="button">
                              <i class="bi bi-copy"></i>
                            </button>
                          </div>
                        </td>
                      </tr>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-light" data-bs-dismiss="modal">
            <i class="bi bi-x-lg me-1"></i>{{__('app.close')}}
          </button>
          <button type="submit" class="btn btn-primary btn-loading">
            <i class="bi bi-check-lg me-1"></i>{{__('app.update')}}
          </button>
        </div>
      </form>
    </div>
</div>
