<script src="{{asset('components/ckeditor/ckeditor.js')}}"></script>
<script src="{{asset('components/ckeditor/plugins/mc_uploader/plugin.js')}}"></script>
<script src="{{asset('assets/js/campaign.js')}}"></script>
<script>
  $(function () {
    $("#action").change(function() {
      var type = $("#action").val();
      @if($action == 'create')
        loadBasedOnAction(type, 'create');
      @endif
    });
    $("#trigger-start").change(function() {
      if(this.value == 'after_event'){
        $("#trigger-start-duration").show('slow');
      } else {
        $("#trigger-start-duration").hide('slow');
      }
    });

    var sendDatetimeElement = document.querySelector("#send_datetime");
    if (sendDatetimeElement) {
        flatpickr("#send_datetime", {
            enableTime: true,
            time_24hr: false, // Use 12-hour format with AM/PM
            minDate: "today",
            dateFormat: "Y-m-d h:i K", // User-friendly format
            defaultDate: sendDatetimeElement.value || null, // Pre-filled value from server
            disableMobile: true,
        onReady: function (selectedDates, dateStr, instance) {
            // Trigger the same behavior as onChange for the default value
            handleDateChange(instance.selectedDates[0], dateStr);
        },
            onChange: function (selectedDates, dateStr, instance) {
                if (selectedDates.length > 0) {
                    handleDateChange(selectedDates[0], dateStr);
                }
            },
        });
    }
  });
  $('[data-bs-toggle="popover"]').popover({
    container: 'body'
  });
</script>
@php
if($action == 'edit') {
  $attributes = json_decode($trigger->attributes);
}
@endphp

@if($type == 'list' || $type == 'date')
<div class="col-md-12 mt-3">
  <label class="form-label">{{__('app.lists')}}
    <a tabindex="-1" role="button"
    data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.lists')}}"
    data-bs-content="{{__('app.trigger_lists_help')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square text-primary"></i>
  </a>
</label>
@php
if($action == 'edit') {
  $list_ids = $attributes->list_ids;
}
@endphp
@include('includes.dropdown_lists', ['popup' => 0, 'multiple' => 1, 'required' => 1, 'client_package_lists' => 1])
</div>
@if($type == 'list' || $type == 'date')
<div class="col-md-12">
  <label class="form-label">{{ __('app.send_to_existing') }}
  <a tabindex="-1" role="button"
    data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.send_to_existing')}}"
    data-bs-content="{{__('app.trigger_send_to_existing_help')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square text-primary"></i>
  </a>
  </label>
  <select class="form-select form-select-lg" name="send_to_existing" required>
    <option value="yes" {{ $action == 'edit' && $attributes->send_to_existing == 'yes' ? 'selected' : '' }}>{{ __('app.yes') }}</option>
    <option value="no" {{ $action == 'edit' && $attributes->send_to_existing == 'no' ? 'selected' : '' }}>{{ __('app.no') }}</option>    
  </select>
</div>
@endif

@elseif($type == 'segment')
<div class="col-md-12 mt-3">
  <label class="form-label">{{__('app.trigger_based_on_segment')}}</label>
@php
if($action == 'edit') {
  $segment_ids = $attributes->segment_ids;
}
@endphp
@include('includes.dropdown_segments', ['multiple' => 0, 'required' => 1])
</div>
<input type="hidden" name="send_to_existing" value="yes">
@endif

@if($type == 'date')
<div class="col-md-12 mt-3">
  <label class="form-label">{{ __('app.sending_datetime') }}
  <a tabindex="-1" role="button"
  data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.sending_datetime')}}"
  data-bs-content="{{__('app.trigger_sending_datetime_help')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square text-primary"></i>
  </a>
  </label>
  <div class="form-group">
    <div class="input-group">
      <div class="input-group-text"> <i class="ri-calendar-line"></i> </div>
      <input type="text" name="send_datetime" class="form-control" id="send_datetime" placeholder="{{ __('app.choose_date_time') }}" value="{{ $action == 'edit' ? \App\Http\Helper\Helper::datetimeDisplay($attributes->send_datetime) : ''}}">
      <input type="hidden" name="db_send_datetime" id="db_send_datetime" value="">
      <input type="hidden" name="timezone" id="timezone" value="{{ \Auth::user()->timezone }}" >
    </div>
  </div>
</div>
@endif

@if($type == 'campaign')
<div class="col-md-12 mt-3">
  <label class="form-label">{{__('app.campaigns')}}</label>
@php
if($action == 'edit') {
  $schedule_campaign_stat_ids = $attributes->schedule_campaign_stat_ids;
}
@endphp
@include('includes.dropdown_campaigns', ['multiple' => 1, 'required' => 1])
</div>

<div class="col-md-12 mt-3">
  <label class="form-label">{{ __('app.criteria') }}
  <a tabindex="-1" role="button"
    data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.criteria')}}"
    data-bs-content="{{__('app.trigger_criteria_help')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square text-primary"></i>
  </a>
  </label>
  <select class="form-select form-select-lg" name="action_campaign" id="action-campaign" required>
    <option value="both">{{ __('app.both_open_not_open') }}</option>
    <option value="is_opened" {{ $action == 'edit' && $attributes->action_campaign == 'both' ? 'selected' : '' }}>{{ __('app.is_opened') }}</option>
    <option value="is_not_opened" {{ $action == 'edit' && $attributes->action_campaign == 'is_not_opened' ? 'selected' : '' }}>{{ __('app.is_not_opened') }}</option>
    <option value="is_clicked" {{ $action == 'edit' && $attributes->action_campaign == 'is_clicked' ? 'selected' : '' }}>{{ __('app.is_clicked') }}</option>
    <option value="is_replied" {{ $action == 'edit' && $attributes->action_campaign == 'is_replied' ? 'selected' : '' }}>{{ __('app.is_replied') }}</option>
  </select>
</div>
<input type="hidden" name="send_to_existing" value="yes">
@endif


@if($type == 'list' || $type == 'date' || $type == 'segment' || $type == 'campaign')
<div class="col-md-12 mt-3">
  <label class="form-label">{{ __('app.action') }}
  <a tabindex="-1" role="button"
    data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.action')}}"
    data-bs-content="{{__('app.trigger_action_help')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square text-primary"></i>
  </a>
  </label>
  @if($action == 'create')
  <select class="form-select form-select-lg" name="action" id="action" required>
    <option value="send_campaign">{{ __('app.send_campaign') }}</option>
    @if($type == 'list' || $type == 'date')
      <option value="start_drip">{{ __('app.start_drip') }}</option>
    @endif
  </select>
  @else
    <label class="form-control">{{ ucwords(str_replace('_', ' ', $trigger->action)) }}</label>
  @endif
</div>
@endif

@if($type == 'send_campaign')
<div class="col-md-12 mt-3">
  <label class="form-label">{{__('app.subject')}}</label>
  <a tabindex="-1" role="button"
  data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.subject')}}"
  data-bs-content="{{__('app.subject_help')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square text-primary"></i>
</a>
<input type="text" class="form-control" placeholder="{{__('app.subject')}}" value="{{ $attributes->email_subject ?? ''  }}" name="email_subject" id="email_subject">
</div>

<div class="col-md-12 mt-3">
  <label class="form-label">{{__('app.content')}} <span class="ps-5"></span></label>
  {!! \App\Http\Helper\Helper::contentEditorButtons('content_html', true, true, true, true, true) !!}
  <textarea class="form-control" id="content_html" name="content_html" rows="10">{{ $attributes->content_html ?? ''  }}</textarea>
</div>
@elseif($type == 'start_drip')
<div class="col-md-12 mt-3">
  <label class="form-label">{{ __('app.drip_group') }}</label>
  <select class="form-select form-select-lg" name="drip_group_id" id="groups" required>
    <option value="">{{ __('app.select_drip_group') }}</option>
    @foreach(\App\Models\Group::groups(config('custom.group_drips')) as $id => $name)
      <option value="{{ $id }}" {{$action == 'edit' && !empty($attributes->drip_group_id) && $attributes->drip_group_id == $id ? 'selected' : ''}}>{{ $name }}</option>
    @endforeach
  </select>
</div>
@endif

@if($type == 'send_campaign')
<div class="col-md-12 mt-3">
  <label class="form-label">{{ __('app.trigger_start') }}
  <a tabindex="-1" role="button"
    data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.trigger_start')}}"
    data-bs-content="{{__('app.trigger_start_help')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square text-primary"></i>
  </a>
  </label>
  <select name="trigger_start" id="trigger-start" class="form-select form-select-lg">
    <option value="instant" {{$action == 'edit' && $attributes->trigger_start == 'instant' ? 'selected' : ''}}>{{ __('app.instant') }}</option>
    <option value="after_event" {{$action == 'edit' && $attributes->trigger_start == 'after_event' ? 'selected' : ''}}>{{ __('app.after_event') }}</option>
  </select>
</div>

<div class="row" id="trigger-start-duration" style="display: {{$action == 'create' ? 'none' : ($action == 'edit' && $attributes->trigger_start == 'instant' ? 'none' : '')}};">

  <div class="col-md-6 mt-3">
    <label class="form-label">{{ __('app.trigger_start_duration') }}</label>
    <input type="input" class="form-control" name="trigger_start_limit" value="{{ $attributes->trigger_start_limit ?? '5' }}">
  </div>
  <div class="col-md-6 mt-3">
    <label class="form-label">&nbsp;</label>
    <select name="trigger_start_duration" class="form-select form-select-lg" >
      <option value="minutes" {{$action == 'edit' && $attributes->trigger_start_duration == 'minutes' ? 'selected' : ''}}>{{ __('app.minutes') }}</option>
      <option value="hours" {{$action == 'edit' && $attributes->trigger_start_duration == 'hours' ? 'selected' : ''}}>{{ __('app.hours') }}</option>
      <option value="days" {{$action == 'edit' && $attributes->trigger_start_duration == 'days' ? 'selected' : ''}}>{{ __('app.days') }}</option>
    </select>
  </div>
</div>
@endif
