@extends('layouts.app')
@section('title', $page_title)

@section('styles')
<link href="{{asset('assets/css/schedule.css')}}" rel="stylesheet" >
<style>
/* Email input group styling */
.input-group > .select2-container {
  flex: 1 1 auto;
  width: auto !important;
}
#from_email_part1 {
  height: 100%;
}
</style>
@endsection

@push('scripts')
<script>
loadBasedOnData('list', 'create');
loadBasedOnAction('send_campaign', 'create');

$(document).ready(function() {
  // Initialize Select2 for email domain dropdown
  $('#sending-domains').select2({
    placeholder: '{{__("app.select_domain")}}',
    allowClear: false,
    width: '100%'
  });
  
  // Add validation for sending server multiselect
  var forms = document.getElementsByClassName('needs-validation');
  Array.prototype.filter.call(forms, function (form) {
    form.addEventListener('submit', function (event) {
      var formIsValid = form.checkValidity();
      
      // Validate lists only when based_on is "list" or "date"
      const basedOnValue = document.getElementById("based-on-trigger") ? document.getElementById("based-on-trigger").value : null;
      const listDropdown = document.getElementById("list_ids");
      var listValid = true;
      
      // Only validate lists if based_on is "list" or "date"
      if ((basedOnValue === 'list' || basedOnValue === 'date') && listDropdown && !listDropdown.disabled) {
        var listSelectedValues = $(listDropdown).val();
        var isValid = false;
        
        if (listSelectedValues === null || listSelectedValues === undefined) {
          isValid = false;
        } else if (Array.isArray(listSelectedValues)) {
          var validValues = listSelectedValues.filter(function(val) { 
            return val !== '' && val !== null && val !== undefined && String(val).trim() !== ''; 
          });
          isValid = validValues.length > 0;
        } else if (typeof listSelectedValues === 'string') {
          isValid = listSelectedValues.trim() !== '' && listSelectedValues !== null;
        }
        
        if (isValid) {
          var $selectedOptions = $(listDropdown).find('option:selected[value!=""]');
          isValid = $selectedOptions.length > 0;
        }
        
        listValid = isValid;
        
        var $listMultiselectBtn = $(listDropdown).next('.btn-group').find('.multiselect');
        if ($listMultiselectBtn.length === 0) {
          $listMultiselectBtn = $(listDropdown).siblings('.btn-group').find('.multiselect');
        }
        if ($listMultiselectBtn.length === 0) {
          $listMultiselectBtn = $(listDropdown).closest('.form-group, .col-md-12, .col-12').find('.multiselect');
        }
        
        if (!isValid) {
          if ($listMultiselectBtn.length > 0) {
            $listMultiselectBtn.addClass("is-invalid").css({
              'border-color': '#dc3545',
              'box-shadow': '0 0 0 0.2rem rgba(220, 53, 69, 0.25)'
            });
          }
          $(listDropdown).addClass("is-invalid");
          var $feedback = $('#list_ids_feedback');
          if ($feedback.length === 0) {
            $feedback = $(listDropdown).next('.invalid-feedback');
          }
          if ($feedback.length === 0) {
            $feedback = $(listDropdown).siblings('.invalid-feedback');
          }
          if ($feedback.length === 0) {
            $feedback = $(listDropdown).closest('.form-group, .col-md-12, .col-12').find('.invalid-feedback');
          }
          if ($feedback.length > 0) {
            $feedback.show();
          }
        } else {
          if ($listMultiselectBtn.length > 0) {
            $listMultiselectBtn.removeClass("is-invalid").css({
              'border-color': '',
              'box-shadow': ''
            });
          }
          $(listDropdown).removeClass("is-invalid");
          var $feedback = $('#list_ids_feedback');
          if ($feedback.length === 0) {
            $feedback = $(listDropdown).next('.invalid-feedback');
          }
          if ($feedback.length === 0) {
            $feedback = $(listDropdown).siblings('.invalid-feedback');
          }
          if ($feedback.length === 0) {
            $feedback = $(listDropdown).closest('.form-group, .col-md-12, .col-12').find('.invalid-feedback');
          }
          if ($feedback.length > 0) {
            $feedback.hide();
          }
        }
      }
      
      // Always validate sending server
      const sendingServerDropdown = document.getElementById("sending_server_ids");
      var sendingServerValid = true;
      
      if (sendingServerDropdown) {
        var selectedValues = $(sendingServerDropdown).val();
        var isValid = false;
        
        if (selectedValues === null || selectedValues === undefined) {
          isValid = false;
        } else if (Array.isArray(selectedValues)) {
          var validValues = selectedValues.filter(function(val) { 
            return val !== '' && val !== null && val !== undefined && String(val).trim() !== ''; 
          });
          isValid = validValues.length > 0;
        } else if (typeof selectedValues === 'string') {
          isValid = selectedValues.trim() !== '' && selectedValues !== null;
        }
        
        if (isValid) {
          var $selectedOptions = $(sendingServerDropdown).find('option:selected[value!=""]');
          isValid = $selectedOptions.length > 0;
        }
        
        sendingServerValid = isValid;
        
        var $multiselectBtn = $(sendingServerDropdown).next('.btn-group').find('.multiselect');
        if ($multiselectBtn.length === 0) {
          $multiselectBtn = $(sendingServerDropdown).siblings('.btn-group').find('.multiselect');
        }
        if ($multiselectBtn.length === 0) {
          $multiselectBtn = $(sendingServerDropdown).closest('.form-group, .col-md-12, .col-12').find('.multiselect');
        }
        
        if (!isValid) {
          if ($multiselectBtn.length > 0) {
            $multiselectBtn.addClass("is-invalid").css({
              'border-color': '#dc3545',
              'box-shadow': '0 0 0 0.2rem rgba(220, 53, 69, 0.25)'
            });
          }
          $(sendingServerDropdown).addClass("is-invalid");
          var $feedback = $('#sending_server_ids_feedback');
          if ($feedback.length === 0) {
            $feedback = $(sendingServerDropdown).next('.invalid-feedback');
          }
          if ($feedback.length === 0) {
            $feedback = $(sendingServerDropdown).siblings('.invalid-feedback');
          }
          if ($feedback.length === 0) {
            $feedback = $(sendingServerDropdown).closest('.form-group, .col-md-12, .col-12').find('.invalid-feedback');
          }
          if ($feedback.length > 0) {
            $feedback.show();
          }
        } else {
          if ($multiselectBtn.length > 0) {
            $multiselectBtn.removeClass("is-invalid").css({
              'border-color': '',
              'box-shadow': ''
            });
          }
          $(sendingServerDropdown).removeClass("is-invalid");
          var $feedback = $('#sending_server_ids_feedback');
          if ($feedback.length === 0) {
            $feedback = $(sendingServerDropdown).next('.invalid-feedback');
          }
          if ($feedback.length === 0) {
            $feedback = $(sendingServerDropdown).siblings('.invalid-feedback');
          }
          if ($feedback.length === 0) {
            $feedback = $(sendingServerDropdown).closest('.form-group, .col-md-12, .col-12').find('.invalid-feedback');
          }
          if ($feedback.length > 0) {
            $feedback.hide();
          }
        }
      }
      
      // Prevent submission if form is invalid OR lists is invalid OR sending server is invalid
      if (!formIsValid || !listValid || !sendingServerValid) {
        event.preventDefault();
        event.stopPropagation();
        // Remove button loader if validation fails
        $(".btn-loading").find("i").removeClass("spinner-border spinner-border-sm align-middle");
      }
      
      form.classList.add('was-validated');
    }, false);
  });
  
  // Clear validation on change for lists
  $('#list_ids').on('change', function() {
    var $select = $(this);
    if ($select.prop('disabled')) return; // Skip if disabled
    
    var selectedValues = $select.val();
    var hasSelection = false;
    
    if (selectedValues === null || selectedValues === undefined) {
      hasSelection = false;
    } else if (Array.isArray(selectedValues)) {
      var validValues = selectedValues.filter(function(val) { 
        return val !== '' && val !== null && val !== undefined && String(val).trim() !== ''; 
      });
      hasSelection = validValues.length > 0;
    } else if (typeof selectedValues === 'string') {
      hasSelection = selectedValues.trim() !== '' && selectedValues !== null;
    }
    
    if (hasSelection) {
      var $selectedOptions = $select.find('option:selected[value!=""]');
      hasSelection = $selectedOptions.length > 0;
    }
    
    var $multiselectBtn = $select.next('.btn-group').find('.multiselect');
    if ($multiselectBtn.length === 0) {
      $multiselectBtn = $select.siblings('.btn-group').find('.multiselect');
    }
    if ($multiselectBtn.length === 0) {
      $multiselectBtn = $select.closest('.form-group, .col-md-12, .col-12').find('.multiselect');
    }
    
    if (hasSelection) {
      $select.removeClass("is-invalid");
      if ($multiselectBtn.length > 0) {
        $multiselectBtn.removeClass("is-invalid").css({
          'border-color': '',
          'box-shadow': ''
        });
      }
      var $feedback = $('#list_ids_feedback');
      if ($feedback.length === 0) {
        $feedback = $select.next('.invalid-feedback');
      }
      if ($feedback.length === 0) {
        $feedback = $select.siblings('.invalid-feedback');
      }
      if ($feedback.length === 0) {
        $feedback = $select.closest('.form-group, .col-md-12, .col-12').find('.invalid-feedback');
      }
      if ($feedback.length > 0) {
        $feedback.hide();
      }
    }
  });
  
  // Clear validation on change for sending server
  $('#sending_server_ids').on('change', function() {
    var $select = $(this);
    var selectedValues = $select.val();
    var hasSelection = false;
    
    if (selectedValues === null || selectedValues === undefined) {
      hasSelection = false;
    } else if (Array.isArray(selectedValues)) {
      var validValues = selectedValues.filter(function(val) { 
        return val !== '' && val !== null && val !== undefined && String(val).trim() !== ''; 
      });
      hasSelection = validValues.length > 0;
    } else if (typeof selectedValues === 'string') {
      hasSelection = selectedValues.trim() !== '' && selectedValues !== null;
    }
    
    if (hasSelection) {
      var $selectedOptions = $select.find('option:selected[value!=""]');
      hasSelection = $selectedOptions.length > 0;
    }
    
    var $multiselectBtn = $select.next('.btn-group').find('.multiselect');
    if ($multiselectBtn.length === 0) {
      $multiselectBtn = $select.siblings('.btn-group').find('.multiselect');
    }
    if ($multiselectBtn.length === 0) {
      $multiselectBtn = $select.closest('.form-group, .col-md-12, .col-12').find('.multiselect');
    }
    
    if (hasSelection) {
      $select.removeClass("is-invalid");
      if ($multiselectBtn.length > 0) {
        $multiselectBtn.removeClass("is-invalid").css({
          'border-color': '',
          'box-shadow': ''
        });
      }
      var $feedback = $('#sending_server_ids_feedback');
      if ($feedback.length === 0) {
        $feedback = $select.next('.invalid-feedback');
      }
      if ($feedback.length === 0) {
        $feedback = $select.siblings('.invalid-feedback');
      }
      if ($feedback.length === 0) {
        $feedback = $select.closest('.form-group, .col-md-12, .col-12').find('.invalid-feedback');
      }
      if ($feedback.length > 0) {
        $feedback.hide();
      }
    }
  });
});
</script>
@endpush

@section('content')
<div class="row">
  <div class="col-12">
    <div class="card custom-card">
      <div class="card-body">
        <form method="POST" action="{{ route('triggers.store') }}" class="needs-validation" novalidate>
          @csrf
          
          <!-- Basic Information Section -->
          <div class="row mb-3">
            
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.name')}}</label>
                <input type="text" class="form-control" placeholder="{{__('app.name')}}"
                aria-label="{{__('app.name')}}" value="{{ old('name') }}"  name="name" required>
                <div class="invalid-feedback">{{__('app.name_required')}}</div>
              </div>
            </div>
            
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.status')}}</label>
                <select class="form-select form-select-lg" name="is_active">
                   <option value="1">{{__('app.active')}}</option>
                   <option value="0">{{__('app.in_active')}}</option>
                </select>
              </div>
            </div>
            
            <div class="col-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.detail')}}</label>
                <textarea class="form-control" placeholder="{{__('app.detail')}}" rows="3" name="detail">{{ old('detail') }}</textarea>
              </div>
            </div>
          </div>
          <!-- Trigger Configuration Section -->
          <div class="row mb-3">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-gear"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.trigger_configuration')}}</h6>
              </div>
            </div>
            
            <div class="col-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{ __('app.based_on') }}
                   <a tabindex="-1" role="button"
                    data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.based_on')}}"
                    data-bs-content="{{__('app.trigger_based_on_help')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square text-primary"></i>
                    </a>
                 </label>
                <select class="form-select form-select-lg" name="based_on" id="based-on-trigger">
                   <option value="list">{{ __('app.trigger_based_on_list') }}</option>
                   <option value="segment">{{ __('app.trigger_based_on_segment') }}</option>
                   <option value="campaign">{{ __('app.trigger_based_on_campaign') }}</option>
                   <option value="date">{{ __('app.trigger_based_on_date') }}</option>               
                </select>
              </div>
            </div>
            
            <div class="col-12">
              <div id="based-on-data"></div>
              <div id="action-data"></div>
            </div>
          </div>
          <!-- Delivery Settings Section -->
          <div class="row">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-send"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.sending_configuration')}}</h6>
              </div>
            </div>
            
            <div class="col-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.delivery_servers')}}
                   <a tabindex="-1" role="button"
                   data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.lists')}}"
                   data-bs-content="{{__('app.packages_delivery_servers')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square text-primary"></i>
                   </a>
                 </label>
                 @include('includes.dropdown_sending_server', ['popup' => 0, 'multiple' => 1, 'required' => 1])
              </div>
            </div>
          </div>
          <!-- Sender Information Section -->
          <div class="row mb-3">            
            <div class="col-12">
              <div class="form-group">
                <label class="form-label fw-semibold">{{__('app.from_detail')}}
                   <a tabindex="-1" role="button"
                    data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.from_detail')}}"
                    data-bs-content="{{__('app.from_detail_help')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square text-primary"></i>
                    </a>
                 </label><br>
                  <input name="from_detail" class="form-check-input ms-2" type="radio" checked="checked" value="sending_server"> {{__('app.as_defined_for_sending_server')}} &nbsp;
                  <input name="from_detail" class="form-check-input ms-2" type="radio" value="list"> {{__('app.as_defined_for_list')}} &nbsp;
                  <input name="from_detail" class="form-check-input ms-2" type="radio" value="custom"> {{__('app.custom')}}
              </div>
            </div>
            
            <div class="row mt-3" id="custom_email_data" style="display: none;">
                <div class="col-md-3">
                   <div class="form-group">
                     <label class="form-label fw-semibold">{{__('app.from_name')}}</label>
                     <input type="text" class="form-control" placeholder="{{__('app.from_name')}}" value="" name="from_name">
                   </div>
                </div>
                <div class="col-md-5">
                   <div class="form-group">
                     <label class="form-label fw-semibold">{{__('app.from_email')}}</label>
                     <div class="input-group">
                        <div style="width: 35%;">
                          <input type="text" name="from_email_part1" value="" class="form-control" placeholder="{{__('app.from_email_example')}}">
                        </div>
                        <span class="input-group-text">@</span>
                        <select name="from_email_part2" id="sending-domains" class="single-select form-select">
                          @include('includes.dropdown_sending_domains')
                        </select>
                      </div>
                   </div>
                </div>
                <div class="col-md-4">
                   <div class="form-group">
                     <label class="form-label fw-semibold">{{__('app.reply_email')}}</label>
                     <input type="email" class="form-control" placeholder="{{__('app.reply_email')}}" value="" name="reply_email">
                   </div>
                </div>
            </div>
          </div>
          <!-- Sending Speed Section -->
          <div class="row mb-3">            
            <div class="col-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{ __('app.sending_speed') }}
                   <a tabindex="-1" role="button"
                   data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.sending_speed')}}"
                   data-bs-content="{{__('app.sending_speed_help')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square text-primary"></i>
                  </a>
               </label>
                <select class="form-select form-select-lg" name="sending_speed" id="speed">
                   <option value="unlimited">{{ __('app.unlimited') }}</option>
                   <option value="limited">{{ __('app.limited') }}</option>
                </select>
              </div>
            </div>
            
            <div class="col-12" id="speed-attributes" style="display: none;">
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label class="form-label fw-semibold mt-2">{{__('app.limit')}}</label>
                    <input type="number" class="form-control" name="limit" id="limit" value="1000" min="1" placeholder="1000">
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label class="form-label fw-semibold mt-2">{{__('app.duration')}}</label>
                    <select name="duration" id="duration" class="form-select form-select-lg" >
                      <option value="hour">{{ __('app.hourly') }}</option>
                    </select>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <!-- Action Buttons -->
          <div class="row">
            <div class="col-12">
              <div class="d-flex gap-2 justify-content-end">
                <a href="{{route('triggers.index')}}" class="btn btn-light">
                  <i class="bi bi-arrow-left me-1"></i>{{__('app.cancel')}}
                </a>
                <button type="submit" name="save_continue" value="1" class="btn btn-primary btn-loading">
                  <i class="bi bi-save me-1"></i>{{__('app.save_continue')}}
                </button>
                <button type="submit" name="save_exit" value="1" class="btn btn-success btn-loading">
                  <i class="bi bi-check-lg me-1"></i>{{__('app.save_exit')}}
                </button>
              </div>
            </div>
          </div>
      </form>
   </div>
</div>
@endsection
