@extends('layouts.app')
@section('title', $page_title)

{{-- Include global DataTable styling --}}
@include('components.datatable-styles')

@push('scripts')
<script>
$(function () {
  var datatable = $('#data').DataTable({
    "columnDefs": [{"sortable": false, "targets": [0, 6]}],
    "order": [[0, "DESC"]],
    "lengthMenu": [[50, 100], [50, 100]],
    "ajax": $('#route-triggers').data('route'),
  });
  $("#modal").on("hidden.bs.modal", function () {
    datatable.ajax.reload(null, false); // user paging is not reset on reload
  });
  
  // Handle Add Trigger button click with error handling
  $('#add-trigger-btn').on('click', function(e) {
    e.preventDefault();
    var href = $(this).attr('href');
    var $btn = $(this);
    var $icon = $btn.find('i');
    
    // Show loading spinner
    $icon.removeClass('bi-plus-circle').addClass('spinner-border spinner-border-sm');
    
    // Try to navigate to the create page
    $.ajax({
      url: href,
      type: 'GET',
      success: function() {
        // If successful, navigate to the page
        window.location.href = href;
      },
      error: function(xhr) {
        // Reset button
        $icon.removeClass('spinner-border spinner-border-sm').addClass('bi-plus-circle');
        
        if (xhr.status === 401) {
          alert('You do not have permission to create triggers. Please contact your administrator.');
        } else if (xhr.status === 403) {
          alert('Access forbidden. You do not have the required permissions.');
        } else {
          alert('An error occurred while trying to access the create trigger page. Please try again.');
        }
      }
    });
  });
});
</script>
@endpush

@section('content')
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-body">
                <div class="table-responsive">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <a href="{{route('triggers.create')}}" class="btn btn-primary btn-loading" id="add-trigger-btn" style="margin: 0px; display: none;">
                                <i class="bi bi-plus-circle me-2"></i>{{__('app.add_new_trigger')}}
                            </a>
                        </div>
                        <div class="col-md-6 text-end">
                            <div class="btn-group">
                                <button type="button" class="btn btn-outline-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="bi bi-gear me-1"></i>{{__('app.actions')}}
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="javascript:;" onclick="destroyMany('{{ route('triggers.destroy', [0]) }}')">
                                        <i class="bi bi-trash me-2"></i>{{ __('app.delete') }}
                                    </a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id='checkAll' value="0" class="form-check-input"></th>
                                <th>{{ __('app.name') }}</th>
                                  <th>{{ __('app.based_on') }}</th>
                                  <th>{{ __('app.action') }}</th>
                                  <th>{{ __('app.active') }}</th>
                                  <th>{{ __('app.created') }}</th>
                                  <th>{{ __('app.actions') }}</th>
                            </tr>
                        </thead>
                         <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<span id="route-triggers" data-route="{{ route('get.triggers') }}"></span>
@include('includes.datatables')
@endsection
