@extends('layouts.app')
@section('title', $page_title)

@push('scripts')
<script src="{{asset('assets/js/show-password.js')}}"></script>
<script type="text/javascript">
$(document).ready(function() {
   // Initialize timezone select2
   $('#timezone').select2({
       placeholder: '{{__("app.select_timezone")}}',
       allowClear: false,
       width: '100%'
   });
   
   // Initialize language select2
   $('select[name="language"]').select2({
       placeholder: '{{__("app.language")}}',
       allowClear: false,
       width: '100%',
       dropdownParent: $('body')
   });
});
</script>
@endpush

@section('styles')
<style>
/* Language dropdown styling */
.select2-container {
   z-index: 1030 !important; /* Well below Bootstrap modals (1055) but above other elements */
}

.select2-dropdown {
   max-height: 300px;
   overflow-y: auto;
   z-index: 1030 !important;
   position: absolute !important;
}

.select2-results__options {
   max-height: 250px;
   overflow-y: auto;
}

.select2-results__option {
   padding: 8px 12px;
   font-size: 14px;
}

.select2-results__option--highlighted {
   background-color: #007bff;
   color: white;
}

/* Ensure proper scrolling for language dropdown */
.select2-container--default .select2-results > .select2-results__options {
   max-height: 250px;
   overflow-y: auto;
}

.select2-dropdown--below {
   z-index: 1030 !important;
}

/* Ensure form containers don't hide dropdown */
.form-group {
   overflow: visible !important;
}

.col-md-6 {
   overflow: visible !important;
}
</style>
@endsection

@section('content')
<div class="row">
  <div class="col-12">
    <div class="card custom-card">
      <div class="card-body">
        <form method="POST" action="{{ route('users.store') }}" class="needs-validation" novalidate>
          @csrf

          <!-- Basic Information Section -->
          <div class="row mb-3">

            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold">{{__('app.name')}}</label>
                <input type="text" class="form-control" placeholder="{{__('app.name')}}"
                aria-label="{{__('app.name')}}" value="{{ old('name') }}"  name="name" required>
                <div class="invalid-feedback">{{__('app.name_required')}}</div>
              </div>
            </div>

            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold">{{__('app.email')}}</label>
                <input type="email" class="form-control" placeholder="{{__('app.email')}}" value="{{ old('email') }}" name="email" required>
                <div class="invalid-feedback">{{__('app.email_required')}}</div>
              </div>
            </div>

            <div class="col-md-6">
              <div class="form-group">
                <div class="position-relative">
                  <label class="form-label fw-semibold mt-2">{{__('app.password')}}</label>
                  <input id="password"  type="password" class="form-control" placeholder="{{__('app.password')}}" name="password" required>
                  <a href="javascript:void(0);" class="show-password-button " onclick="createpassword('password',this)" id="button-addon2"><i class="ri-eye-off-line align-middle text-primary"></i></a>
                  <div class="invalid-feedback">{{__('app.password_required')}}</div>
                </div>
              </div>
            </div>

            <div class="col-md-6">
              <div class="form-group">
                <div class="position-relative">
                  <label class="form-label fw-semibold mt-2">{{__('app.confirm_password')}}</label>
                  <input id="confirm-password" type="password" class="form-control" placeholder="{{__('app.confirm_password')}}" name="confirm-password" required>
                  <a href="javascript:void(0);" class="show-password-button " onclick="createpassword('confirm-password',this)" id="button-addon2"><i class="ri-eye-off-line align-middle text-primary"></i></a>
                  <div class="invalid-feedback">{{__('app.confirm_password_required')}}</div>
                </div>
              </div>
            </div>

            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.address')}}</label>
                <input type="text" class="form-control" placeholder="{{__('app.address')}}" name="address"  value="{{ old('address') }}">
              </div>
            </div>

            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.phone')}}</label>
                <input type="text" class="form-control" name="phone"  value="{{ old('phone') }}">
              </div>
            </div>
          </div>

          <!-- Preferences Section -->
          <div class="row mb-3">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-gear"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.preferences')}}</h6>
              </div>
            </div>

            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.language')}}</label>
                <select name="language" class="single-select form-select">
                   @foreach(\App\Http\Helper\Helper::languages() as $key => $language)
                   <option value="{{ $key }}" {{ old('language') == $key ? 'selected' : '' }}>{{ $language }}</option>
                   @endforeach
                </select>
              </div>
            </div>

            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.timezone')}}</label>
                <select name="timezone" id="timezone" class="single-select form-select" required>
                   <option value="">{{__('app.select_timezone')}}</option>
                   @foreach(\App\Http\Helper\Helper::timeZones() as $key => $timezone)
                   <option value="{{ $key }}" {{ old('timezone') == $key ? 'selected' : '' }}>{{ $timezone }}</option>
                   @endforeach
                </select>
                <div class="invalid-feedback">{{__('app.timezone_required')}}</div>
              </div>
            </div>
          </div>

          <!-- Access Control Section -->
          <div class="row mb-3">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-person-gear"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.access_control')}}</h6>
              </div>
            </div>

            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.role')}}
                   <a href="{{route('roles.create')}}" class="text-primary ms-1">
                      <i class="bi bi-plus-circle"></i>
                   </a>
                </label>
                <select name="roles" class="form-select form-select-lg" required>
                   <option value="">{{__('app.select_role')}}</option>
                   @foreach ($roles as $role)
                   <option value="{{ $role->name }}" {{ old('roles') == $role->name ? 'selected' : '' }}>
                      {{ $role->display_name }}
                   </option>
                   @endforeach
                </select>
                <div class="invalid-feedback">{{__('app.role_required')}}</div>
              </div>
            </div>

            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.status')}}</label>
                <select class="form-select form-select-lg" name="is_active">
                   <option value="1">{{__('app.active')}}</option>
                   <option value="0">{{__('app.in_active')}}</option>
                </select>
              </div>
            </div>
          </div>

          <!-- Action Buttons -->
          <div class="row">
            <div class="col-12">
              <div class="d-flex gap-2 justify-content-start">
                <button type="submit" class="btn btn-primary">
                  <i class="bi bi-check-lg me-1"></i>{{__('app.create')}}
                </button>
                <a href="{{route('users.index')}}" class="btn btn-light">
                  <i class="bi bi-arrow-left me-1"></i>{{__('app.cancel')}}
                </a>
              </div>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
@endsection
