<script src="{{asset('assets/js/app.js')}}"></script>
<style>
/* Ensure popovers appear above modals */
.popover {
    z-index: 9999 !important;
}
</style>
<script>
$(document).ready(function() {
  // Initialize popovers
  $('[data-bs-toggle="popover"]').popover({
    container: 'body'
  });

  // Initialize Select2 for growth factor dropdown when modal is shown
  // This ensures the element exists before initialization
  $('#modal').on('shown.bs.modal', function() {
    var $growthFactor = $('#growth_factor');
    
    // Destroy existing Select2 instance if it exists
    if ($growthFactor.hasClass('select2-hidden-accessible')) {
      $growthFactor.select2('destroy');
    }
    
    // Initialize Select2 if library is available
    if (typeof $.fn.select2 !== 'undefined' && $growthFactor.length > 0) {
      $growthFactor.select2({
        dir: "ltr",
        minimumResultsForSearch: Infinity,
        dropdownParent: $('#modal .modal-content'),
        width: '100%'
      });
    } else if ($growthFactor.length > 0) {
      // Retry if Select2 is not loaded yet
      setTimeout(function() {
        if (typeof $.fn.select2 !== 'undefined' && $growthFactor.length > 0) {
          $growthFactor.select2({
            dir: "ltr",
            minimumResultsForSearch: Infinity,
            dropdownParent: $('#modal .modal-content'),
            width: '100%'
          });
        }
      }, 200);
    }
  });
  
  // Also try to initialize immediately if modal is already shown (for direct page loads)
  setTimeout(function() {
    var $growthFactor = $('#growth_factor');
    if ($growthFactor.length > 0 && !$growthFactor.hasClass('select2-hidden-accessible')) {
      if (typeof $.fn.select2 !== 'undefined') {
        $growthFactor.select2({
          dir: "ltr",
          minimumResultsForSearch: Infinity,
          dropdownParent: $('#modal .modal-content').length > 0 ? $('#modal .modal-content') : $('body'),
          width: '100%'
        });
      }
    }
  }, 300);
});
</script>
<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
    <div class="modal-content">
      <form id="frm-group" method="post" action="{{route('warmup_plans.store')}}" class="needs-validation" novalidate>
        @csrf
        <div class="modal-header">
          <h6 class="modal-title">{{__('app.add_new_warmup_plan')}}</h6>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{__('app.close')}}"></button>
        </div>
        <div class="modal-body">
          <div class="box-body">
            
            <!-- General Information Section -->
            <div class="row mb-3">
              
              <div class="col-md-12">
                <div class="form-group">
                  <label class="form-label fw-semibold mt-2">{{__('app.name')}}</label>
                  <input type="text" class="form-control" placeholder="{{__('app.name')}}" value="{{ old('name') }}" name="name" required>
                  <div class="invalid-feedback">{{__('app.name_required')}}</div>
                </div>
              </div>
            </div>

            <!-- Plan Configuration Section -->
            <div class="row mb-3">
              <div class="col-12">
                <div class="d-flex align-items-center">
                  <div class="me-3">
                    <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                      <i class="bi bi-gear"></i>
                    </span>
                  </div>
                  <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.plan_configuration')}}</h6>
                </div>
              </div>
              
              <div class="col-md-12">
                <div class="form-group">
                  <label class="form-label fw-semibold mt-2">{{__('app.total_emails')}}
                    <a tabindex="-1" role="button"
                      data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.total_emails')}}"
                      data-bs-content="{{__('app.warmup_plans_total_emails_help')}}" data-bs-custom-class="header-primary">
                      <i class="bi bi-question-square text-primary"></i>
                    </a>
                  </label>
                  <input type="number" class="form-control" placeholder="{{__('app.total_emails')}}" value="{{ old('total_emails') }}" name="total_emails" min="0" required>
                  <div class="invalid-feedback">{{__('app.total_emails_required')}}</div>
                </div>
              </div>
              
              <div class="col-md-12">
                <div class="form-group">
                  <label class="form-label fw-semibold mt-2">{{__('app.growth')}}
                    <a tabindex="-1" role="button"
                      data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.growth')}}"
                      data-bs-content="{{__('app.warmup_plans_growth_help')}}" data-bs-custom-class="header-primary">
                      <i class="bi bi-question-square text-primary"></i>
                    </a>
                  </label>
                  <select name="growth_factor" id="growth_factor" class="single-select form-control">
                    @foreach($growthFactors as $type => $name)
                      <option value="{{ $type }}" {{ old('growth_factor') == $type ? 'selected' : '' }}>{{ $name }}</option>
                    @endforeach
                  </select>
                  <div class="invalid-feedback">{{__('app.growth_required')}}</div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-light" data-bs-dismiss="modal">
            <i class="bi bi-arrow-left me-2"></i>{{__('app.close')}}
          </button>
          <button type="submit" class="btn btn-primary">
            <i class="bi bi-check-circle me-2"></i>{{__('app.create')}}
          </button>
        </div>
      </form>
    </div>
</div>
