@extends('layouts.app')
@section('title', $page_title)

@php
    $schedules = json_decode($warmup_plan->schedule, true);
    $days = array_keys($schedules); // X-axis (Days)
    $emails = array_values($schedules); // Y-axis (Emails)
@endphp
@push('scripts')
<script src="{{asset('components/Chart.js/dist/Chart.min.js')}}"></script>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        var ctx = document.getElementById('warmupChart').getContext('2d');
        var warmupChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: @json($days), // Convert PHP array to JS array
                datasets: [{
                    label: '{{ __("app.emails_send") }}',
                    data: @json($emails),
                    borderColor: '#5C64CC',
                    backgroundColor: 'rgba(0, 0, 255, 0.1)',
                    borderWidth: 2,
                    fill: true,
                    tension: 0.3 // Smooth line
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    x: { title: { display: true, text: 'Day' } },
                    y: { title: { display: true, text: 'Emails Sent' }, beginAtZero: true }
                }
            }
        });
    });
</script>
@endpush

@section('content')
<div class="row">
  <div class="col-12">
    <div class="card custom-card">
      <div class="card-body">
        <form method="POST" action="{{route('warmup_plans.update', $warmup_plan->id)}}" class="needs-validation" novalidate>
          @csrf
          @method('PUT')
          
          <!-- General Information Section -->
          <div class="row mb-4">
            <div class="col-12">
              <div class="d-flex align-items-center justify-content-between mb-3">
                <a tabindex="-1" role="button"
                  data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="left" title="{{__('app.warmup_plan')}}"
                  data-bs-content="{{__('app.warmup_plan_help')}}" data-bs-custom-class="header-primary">
                  <i class="bi bi-question-circle text-primary fs-5"></i>
                </a>
              </div>
            </div>
            
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold">{{__('app.name')}}</label>
                <input type="text" class="form-control" placeholder="{{__('app.name')}}" value="{{ $warmup_plan->name }}" name="name" required>
                <div class="invalid-feedback">{{__('app.name_required')}}</div>
              </div>
            </div>
            
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold">{{__('app.status')}}</label>
                <select name="is_active" class="form-select form-select-lg">
                  <option value="1" {{ $warmup_plan->is_active ? 'selected' : '' }}>{{ __('app.active')}}</option>
                  <option value="0" {{ $warmup_plan->is_active ? '' : 'selected' }}>{{ __('app.in_active') }}</option>
                </select>
              </div>
            </div>
          </div>

          <!-- Plan Details Section -->
          <div class="row mb-4">
            <div class="col-12">
              <div class="d-flex align-items-center mb-3">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-gear"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.plan_details')}}</h6>
              </div>
            </div>
            
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.total_emails')}}</label>
                <div class="input-group">
                  <input type="number" class="form-control" placeholder="{{__('app.total_emails')}}" value="{{ $warmup_plan->total_emails }}" name="total_emails" disabled>
                  <span class="input-group-text"><i class="bi bi-envelope"></i></span>
                </div>
              </div>
            </div>
            
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.growth')}}</label>
                <div class="input-group">
                  <input type="text" class="form-control" placeholder="{{__('app.growth_factor')}}" value="{{ $warmup_plan->growth_factor }}" name="growth_factor" disabled>
                  <span class="input-group-text"><i class="bi bi-graph-up-arrow"></i></span>
                </div>
              </div>
            </div>
          </div>

          <!-- Schedule and Chart Section -->
          <div class="row mb-4">
            <div class="col-12">
              <div class="d-flex align-items-center mb-3">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-calendar-week"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.schedule_visualization')}}</h6>
              </div>
            </div>
            
            <!-- Schedule Table -->
            <div class="col-lg-6 mb-4">
              <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                  <h6 class="mb-0 fw-semibold text-dark">
                    <i class="bi bi-table me-2"></i>{{__('app.daily_schedule')}}
                  </h6>
                </div>
                <div class="card-body p-0">
                  <div class="table-responsive">
                    <table class="table table-hover mb-0">
                      <thead class="table-light">
                        <tr>
                          <th class="fw-semibold">{{__('app.days')}}</th>
                          <th class="fw-semibold text-end">{{__('app.emails')}}</th>
                        </tr>
                      </thead>
                      <tbody>
                        @php $schedules = json_decode($warmup_plan->schedule); @endphp
                        @foreach($schedules as $day => $schedule)
                          <tr class="{{ $loop->even ? 'table-light' : '' }}">
                            <td class="fw-medium">Day {{$day+1}}</td>
                            <td class="text-end fw-semibold text-primary">{{$schedule}}</td>
                          </tr>
                        @endforeach
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>

            <!-- Chart -->
            <div class="col-lg-6 mb-4">
              <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                  <h6 class="mb-0 fw-semibold text-dark">
                    <i class="bi bi-graph-up me-2"></i>{{__('app.growth_chart')}}
                  </h6>
                </div>
                <div class="card-body">
                  <div style="height: 300px;">
                    <canvas id="warmupChart"></canvas>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <!-- Action Buttons -->
          <div class="row">
            <div class="col-12">
              <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary">
                  <i class="bi bi-save me-2"></i>{{__('app.update')}}
                </button>
                <a href="{{route('warmup_plans.index')}}" class="btn btn-light">
                  <i class="bi bi-arrow-left me-2"></i>{{__('app.back_to_list')}}
                </a>
              </div>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
@endsection
