@extends('layouts.app')
@section('title', $page_title)

@push('scripts')
<script>
  $(function() {
   'use strict';
    $("#list_ids").change(function () {
      var listId = $('#list_ids').val();
      
      // Only load custom fields if a list is selected (no loader if empty)
      if (listId && listId !== '' && listId !== null) {
        loadListCustomFieldsWebForms(listId, 'dropdown_custom_fields_form');
      } else {
        // Clear custom fields without loader when no list selected
        $('#list_custom_fields').html('<select class="form-select form-select-lg"></select>');
      }
      
      // Clear validation when list is selected
      if (listId && listId !== '') {
        var $select = $(this);
        $select.removeClass("is-invalid");
        var $feedback = $('#list_ids_feedback');
        if ($feedback.length === 0) {
          $feedback = $select.next('.invalid-feedback');
        }
        if ($feedback.length === 0) {
          $feedback = $select.siblings('.invalid-feedback');
        }
        if ($feedback.length === 0) {
          $feedback = $select.closest('.form-group, .col-md-12, .col-12').find('.invalid-feedback');
        }
        if ($feedback.length > 0) {
          $feedback.hide();
        }
      }
    });

    $("#is_recaptcha").change(function() {
      $("#div_recaptcha_site_key").slideToggle('slow');
    });
    
    // Add validation for list field
    var forms = document.getElementsByClassName('needs-validation');
    Array.prototype.filter.call(forms, function (form) {
      form.addEventListener('submit', function (event) {
        var formIsValid = form.checkValidity();
        
        // Validate lists
        const listDropdown = document.getElementById("list_ids");
        var listValid = true;
        
        if (listDropdown && !listDropdown.disabled) {
          var listSelectedValue = $(listDropdown).val();
          var isValid = false;
          
          if (listSelectedValue === null || listSelectedValue === undefined || listSelectedValue === '') {
            isValid = false;
          } else {
            var $selectedOption = $(listDropdown).find('option:selected[value!=""]');
            isValid = $selectedOption.length > 0 && $selectedOption.val() !== '';
          }
          
          listValid = isValid;
          
          if (!isValid) {
            $(listDropdown).addClass("is-invalid");
            var $feedback = $('#list_ids_feedback');
            if ($feedback.length === 0) {
              $feedback = $(listDropdown).next('.invalid-feedback');
            }
            if ($feedback.length === 0) {
              $feedback = $(listDropdown).siblings('.invalid-feedback');
            }
            if ($feedback.length === 0) {
              $feedback = $(listDropdown).closest('.form-group, .col-md-12, .col-12').find('.invalid-feedback');
            }
            if ($feedback.length > 0) {
              $feedback.show();
            }
          } else {
            $(listDropdown).removeClass("is-invalid");
            var $feedback = $('#list_ids_feedback');
            if ($feedback.length === 0) {
              $feedback = $(listDropdown).next('.invalid-feedback');
            }
            if ($feedback.length === 0) {
              $feedback = $(listDropdown).siblings('.invalid-feedback');
            }
            if ($feedback.length === 0) {
              $feedback = $(listDropdown).closest('.form-group, .col-md-12, .col-12').find('.invalid-feedback');
            }
            if ($feedback.length > 0) {
              $feedback.hide();
            }
          }
        }
        
        if (!formIsValid || !listValid) {
          event.preventDefault();
          event.stopPropagation();
          // Remove button loader if validation fails
          $(".btn-loading").find("i").removeClass("spinner-border spinner-border-sm align-middle");
        }
        
        form.classList.add('was-validated');
      }, false);
    });
  });

  // Load custom fields on page load only if list_id exists
  @if(!empty($webform->list_id))
  loadListCustomFieldsWebForms("{{$webform->list_id}}", 'dropdown_custom_fields_form', "{{$webform->custom_field_ids}}");
  @endif
</script>
@endpush

@php $attributes = json_decode($webform->attributes); @endphp
@section('content')
<div class="row">
  <div class="col-12">
    <div class="card custom-card">
      <div class="card-body">
        <form method="POST" action="{{ route('webforms.update', $webform->id) }}" class="needs-validation" novalidate>
          @csrf
          @method('PUT')

          <!-- Basic Information Section -->
          <div class="row mb-3">

            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.name')}}</label>
                <input type="text" class="form-control" placeholder="{{__('app.name')}}"
                aria-label="{{__('app.name')}}" value="{{ $webform->name }}"  name="name" required>
                <div class="invalid-feedback">{{__('app.name_required')}}</div>
              </div>
            </div>

            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.duplicate')}}
                  <a tabindex="-1" role="button"
                      data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.duplicate')}}"
                      data-bs-content="{{__('app.webform_duplicate_help')}}" data-bs-custom-class="header-primary" class="text-primary ms-1">
                        <i class="bi bi-question-circle"></i>
                    </a>
                </label>
                <select class="form-select form-select-lg" name="duplicates">
                   <option value="Skip" {{ $webform->duplicates == 'Skip' ? 'selected' : '' }}>{{__('app.skip')}}</option>
                   <option value="Overwrite" {{ $webform->duplicates == 'Overwrite' ? 'selected' : '' }}>{{__('app.overwrite')}}</option>
                </select>
              </div>
            </div>
          </div>

          <!-- List Configuration Section -->
          <div class="row mb-3">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-list-ul"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.list_configuration')}}</h6>
              </div>
            </div>

            <div class="col-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.list')}}
                   <a href="{{ route('lists.create') }}" class="text-primary ms-1">
                      <i class="bi bi-plus-circle"></i>
                   </a>
                   <a tabindex="-1" role="button"
                    data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.lists')}}"
                    data-bs-content="{{__('app.list_webform_help')}}" data-bs-custom-class="header-primary" class="text-primary ms-1">
                      <i class="bi bi-question-circle"></i>
                    </a>
                </label>
                @php $list_id = $webform->list_id @endphp
                @include('includes.dropdown_lists', ['popup' => 0, 'multiselect' => 0, 'required' => 1, 'client_package_lists' => 0])
              </div>
            </div>

            <div class="col-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.webform_fields')}}
                <a tabindex="-1" role="button"
                    data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.webform_fields')}}"
                    data-bs-content="{{__('app.list_webform_fields_help')}}" data-bs-custom-class="header-primary" class="text-primary ms-1">
                      <i class="bi bi-question-circle"></i>
                    </a></label>
                <div id="list_custom_fields"><select class="form-select form-select-lg"></select></div>
              </div>
            </div>
          </div>

          <!-- Page Configuration Section -->
          <div class="row mb-3">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-file-text"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.page_configuration')}}</h6>
              </div>
            </div>

            <div class="col-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.thankyou_page_custom_url')}}
                <a tabindex="-1" role="button"
                    data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.thankyou_page_custom_url')}}"
                    data-bs-content="{{__('app.webfrom_thankyou_page_url_help')}}" data-bs-custom-class="header-primary" class="text-primary ms-1">
                      <i class="bi bi-question-circle"></i>
                    </a></label>
                <input type="text" class="form-control" placeholder="{{__('app.thankyou_page_custom_url_help')}}"
                aria-label="{{__('app.thankyou_page_custom_url_help')}}" value="{{$attributes->thankyou_page_custom_url ?? ''}}"  name="thankyou_page_custom_url" required>
                <div class="invalid-feedback">{{__('app.url_required')}}</div>
              </div>
            </div>
          </div>

          <!-- Security Configuration Section -->
          <div class="row mb-3">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-shield-check"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.security_configuration')}}</h6>
              </div>
            </div>

            <div class="col-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.google_recaptcha')}}
                <a tabindex="-1" role="button"
                    data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.google_recaptcha')}}"
                    data-bs-content="{{__('app.google_recaptcha_help')}}" data-bs-custom-class="header-primary" class="text-primary ms-1">
                      <i class="bi bi-question-circle"></i>
                    </a>
                </label>
                <select class="form-select form-select-lg" name="is_recaptcha" id="is_recaptcha">
                   <option value="0" {{ $webform->is_recaptcha ? '' : 'selected' }}>{{__('app.no')}}</option>
                   <option value="1" {{ $webform->is_recaptcha ? 'selected' : '' }}>{{__('app.yes')}}</option>
                </select>
              </div>
            </div>

            <div class="col-12" id="div_recaptcha_site_key" style="{{ $webform->is_recaptcha ? '' : 'display: none;' }}">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.recaptcha_site_key')}}</label>
                <input type="text" class="form-control" placeholder="{{__('app.recaptcha_site_key')}}"
                aria-label="{{__('app.recaptcha_site_key')}}" value="{{ $webform->recaptcha_site_key ?? '' }}"  name="recaptcha_site_key">
              </div>
            </div>
          </div>

          <!-- Action Buttons -->
          <div class="row">
            <div class="col-12">
              <div class="d-flex gap-2 justify-content-start">
                <button type="submit" class="btn btn-primary btn-loading">
                  <i class="bi bi-check-lg me-1"></i>{{__('app.update')}}
                </button>
                <button type="button" class="btn btn-info" onclick="viewModal('modal', '{{route('webforms.show', [$webform->id, 'get_html' => 1])}}');">
                  <i class="bi bi-code me-1"></i>{{__('app.webform_get_html')}}
                </button>
                <a href="{{route('webforms.index')}}" class="btn btn-light">
                  <i class="bi bi-arrow-left me-1"></i>{{__('app.cancel')}}
                </a>
              </div>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
@include('includes.modal')
@endsection
