<style>
.modal-body {
  overflow-y: scroll !important; /* Ensures scrolling */
  scrollbar-width: thin; /* For Firefox */
  scrollbar-color: #888 #f0f0f0; /* Scrollbar track and thumb color */
}
</style>

<script>
  $(function () {
    $('.btn-copy').click(function() {
      document.getElementById("form-html").select();
      document.execCommand("copy");
      toastr.success('Copied successfully!');
    })
  });
</script>
<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
    <div class="modal-content">
        @csrf
        <div class="modal-header">
          <h6 class="modal-title">{{ $webform->name }}</h6>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{__('app.close')}}"></button>
        </div>
        <div class="modal-body">
          <div class="box-body">
          @if($get_html)
          <h6 class="text-info">{!! __('app.customize_from_html') !!}</h6>
            <textarea class="form-control" id="form-html" style="height: 500px;">
          @endif

@if($webform->is_recaptcha)
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
<script>
  function validateRecaptcha(e) {
    var response = grecaptcha.getResponse();
    if (response.length === 0) {
      e.preventDefault();
      alert("Please complete the reCAPTCHA.");
      return false;
    }
    return true;
  }
</script>
@endif
        <form class="form-horizontal" method="post" action="{{ route('webform.save.data') }}" @if($webform->is_recaptcha) onsubmit="return validateRecaptcha(event);" @endif>
            <div class="col-md-12 pt-3">
            <label class="form-label">{{ __('app.email') }}</label>
            <div class="col-md-12">
            <input type="email" class="form-control" placeholder="{{__('app.email')}}"
              aria-label="{{__('app.email')}}" value="{{ old('email') }}"  name="email" required>
            </div>
            </div>
            @php $no_custom_fileld_empty_msg = true; @endphp
            @include('contacts.list_custom_fields')
            <br>
            @if($webform->is_recaptcha)
            <div class="g-recaptcha" data-sitekey="{{ $webform->recaptcha_site_key ?? '' }}"></div>
            @endif
            <div class="col-md-12 mt-3">
                <input type="hidden" name="form_id" value="{{ $webform->id }}">
                <button type="submit" class="btn btn-primary btn-loading">{{ __('app.submit') }}</button>
            </div>
          </form>
          @if($get_html)
            </textarea>
          @endif
        </div>
      </div>
      <div class="modal-footer">
        <div class="d-flex gap-2 justify-content-start">
          <button type="button" class="btn btn-light" data-bs-dismiss="modal">
            <i class="bi bi-x-lg me-1"></i>{{__('app.close')}}
          </button>
          @if($get_html)
            <button type="button" class="btn btn-primary" onclick="viewModal('modal', '{{route('webforms.show', [$webform->id])}}')">
              <i class="bi bi-eye me-1"></i>{{ __('app.view') }}
            </button>
            <button type="button" class="btn btn-info btn-copy">
              <i class="bi bi-copy me-1"></i>{{ __('app.copy') }}
            </button>
          @else
            <button type="button" class="btn btn-primary" onclick="viewModal('modal', '{{route('webforms.show', [$webform->id, 'get_html' => 1])}}')">
              <i class="bi bi-code me-1"></i>{{ __('app.webform_get_html') }}
            </button>
          @endif
        </div>
      </div>
  </div>
</div>
