<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\GroupController;
use App\Http\Controllers\API\ListController;
use App\Http\Controllers\API\CustomFieldController;
use App\Http\Controllers\API\ContactController;
use App\Http\Controllers\API\ClientController;

Route::group(['prefix' => 'v1', 'middleware' => ['auth:api', 'api_status']], function () {

    // Users
    Route::get('/user', function (Request $request) {
        return $request->user();
    });

    // Groups
    Route::get('/group_types', [GroupController::class, 'getGroupTypes']);
    Route::get('/groups', [GroupController::class, 'getGroups']);
    Route::get('/groups/{id}', [GroupController::class, 'get']);
    Route::post('/groups', [GroupController::class, 'add']);
    Route::patch('/groups/{id}', [GroupController::class, 'update']);
    Route::delete('/groups/{id}', [GroupController::class, 'destroy']);

    // Lists
    Route::get('/lists', [ListController::class, 'getLists']);
    Route::get('/lists/{id}', [ListController::class, 'get']);
    Route::post('/lists', [ListController::class, 'add']);
    Route::patch('/lists/{id}', [ListController::class, 'update']);
    Route::delete('/lists/{id}', [ListController::class, 'destroy']);

    // Custom Fields
    Route::get('/custom_fields', [CustomFieldController::class, 'getCustomFields']);
    Route::get('/custom_fields/{id}', [CustomFieldController::class, 'get']);
    Route::post('/custom_fields', [CustomFieldController::class, 'add']);
    Route::patch('/custom_fields/{id}', [CustomFieldController::class, 'update']);
    Route::delete('/custom_fields/{id}', [CustomFieldController::class, 'destroy']);

    // Contacts
    Route::get('/contacts', [ContactController::class, 'getContacts']);
    Route::get('/contacts/{id}', [ContactController::class, 'get']);
    Route::post('/contacts', [ContactController::class, 'add']);
    Route::patch('/contacts/{id}', [ContactController::class, 'update']);
    Route::delete('/contacts/{id}', [ContactController::class, 'destroy']);


    // Clients
    Route::get('/clients', [ClientController::class, 'getClients']);
    Route::get('/clients/{id}', [ClientController::class, 'get']);
    Route::post('/clients', [ClientController::class, 'add']);
    Route::patch('/clients/{id}', [ClientController::class, 'update']);
    Route::delete('/clients/{id}', [ClientController::class, 'destroy']);

});
