<?php
  
use Illuminate\Support\Facades\Route;
  
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ListController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\MiscellaneousController;
use App\Http\Controllers\GroupController;
use App\Http\Controllers\CustomFieldController;
use App\Http\Controllers\SuppressionController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\BroadcastController;
use App\Http\Controllers\TemplateController;
use App\Http\Controllers\SpintagController;
use App\Http\Controllers\ReplyServerController;
use App\Http\Controllers\BounceController;
use App\Http\Controllers\FblController;
use App\Http\Controllers\TrackingDomainController;
use App\Http\Controllers\SendingDomainController;
use App\Http\Controllers\EmailPageController;
use App\Http\Controllers\SendingServerController;
use App\Http\Controllers\ScheduleCampaignController;
use App\Http\Controllers\ScheduleCampaignStatController;
use App\Http\Controllers\TrackingController;
use App\Http\Controllers\BlacklistController;
use App\Http\Controllers\ToolController;
use App\Http\Controllers\CallbackController;
use App\Http\Controllers\InstallController;
use App\Http\Controllers\SegmentationController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\PackageController;
use App\Http\Controllers\TriggerController;
use App\Http\Controllers\TriggerScheduleStatController;
use App\Http\Controllers\DripController;
use App\Http\Controllers\DripScheduleStatController;
use App\Http\Controllers\SplitTestController;
use App\Http\Controllers\SplitTestStatController;
use App\Http\Controllers\WebformController;
use App\Http\Controllers\WarmupPlanController;
use App\Http\Controllers\EmailVerifierController;
use App\Http\Controllers\NoteController;
use App\Http\Controllers\PmtaController;

Route::get("/migrate", function () {
    try {
        // Clear caches before migration
        collect(['route:clear', 'cache:clear', 'config:cache', 'view:clear'])->each(fn($cmd) => Artisan::call($cmd));

        // Run migration
        Artisan::call('migrate', ['--force' => true]);
        $output = Artisan::output();

        return response()->json([
            'success' => true,
            'msg' => 'Migration executed successfully',
            'output' => $output
        ], 200);
    } catch (\Exception $e) {
        return response()->json([
            'success' => false,
            'msg' => 'Migration failed',
            'error' => $e->getMessage()
        ], 500);
    }
})->name('migrate');

Route::get("/clear_cache", function () {
    collect(['cache:clear', 'route:clear', 'config:cache', 'view:clear'])->each(fn($cmd) => Artisan::call($cmd));

    return response()->json([
        'success' => true,
        'msg' => 'Cache has been cleared'
    ], 200);
})->name('clear.cache');



// custom reset password notification
Auth::routes(['reset' => true]);   
Auth::routes();

Route::group(['middleware' => ['auth','language']], function() {
    Route::get('/', [DashboardController::class, 'index']);
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('/campaigns/sent/{type?}', [DashboardController::class, 'getSentData'])->name('campaigns.sent.data');

    // impersonate user
    Route::post('/impersonate/{id}', function($id){
        Auth::loginUsingId($id);
        if($id == config('custom.app_id')) 
            Session::forget('impersonate');
        else
            session(['impersonate' => true]);
        return redirect()->route('dashboard');
    })->name('user.impersonate');

    Route::resource('roles', RoleController::class)->except(['show']);
    Route::get('/get_roles', [RoleController::class, 'getRoles'])->name('roles');
    Route::resource('users', UserController::class)->except(['show']);
    Route::get('/get_users', [UserController::class, 'getUsers'])->name('users');
    Route::get('/profile', [UserController::class, 'profile'])->name('profile');
    Route::get('/settings', [SettingController::class, 'index'])->name('settings');
    Route::put('/settings/{id}', [SettingController::class, 'update'])->name('settings.update');

    Route::any('/api', [SettingController::class, 'api'])->name('api');
    Route::put('/api-status', [SettingController::class, 'apiStatus'])->name('api.status');

    // Mis
    Route::get('/activity_logs', [MiscellaneousController::class, 'activityLogs'])->name('activity.logs');
    Route::get('/get_activity_logs', [MiscellaneousController::class, 'getActivityLogs'])->name('activitylogs');
    Route::get('/error_logs', [MiscellaneousController::class, 'errorLogs'])->name('error.logs');
    Route::get('/error-logs/clear', function(){
        \App\Http\Helper\Helper::clearErrorLogs();
        return redirect()->route('error.logs');
    })->name('error.logs.clear');

    Route::get('/php_info', [MiscellaneousController::class, 'phpInfo'])->name('php.info');
    Route::get('/get_php_info', function () {
        phpinfo();
    });
    Route::get('/notifications', [MiscellaneousController::class, 'notifications'])->name('notifications');
    Route::get('/get_notifications', [MiscellaneousController::class, 'getNotifications'])->name('get.notifications');
    Route::delete('/notifications_destroy/{id}', [MiscellaneousController::class, 'destroyNotificatoins'])->name('notifications.delete');

    Route::get('/update', [ToolController::class, 'update'])->name('update');
    Route::post('/update_app', [ToolController::class, 'updateApp'])->name('update.app');
    Route::post('/refresh_license', [ToolController::class, 'refreshLicense'])->name('license.refresh');

    Route::get('/backup', function(){
        \App\Http\Helper\Helper::checkPermissions('backup'); // check user permission
        return view('tools.backup');
    })->name('backup');
    Route::post('/backup', [ToolController::class, 'backup'])->name('backup');

    Route::get('/help', function() {
        return view('includes.help');
    })->name('help');
    Route::post('/help_send', [ToolController::class, 'helpSend']);

    Route::get('/image_manager', function() {
        \App\Http\Helper\Helper::checkPermissions('image_manager');
        $page = 'tools_image_manager';
        $page_title = __('app.image_manager');
        $breadcrumbs = [__('app.tools') => '#',__('app.image_manager') => '#'];
        return view('miscellaneous.image_manager',compact('page', 'page_title', 'breadcrumbs'));
    })->name('image.manager');

    // Lists
    Route::resource('lists', ListController::class);
    Route::get('/get_lists', [ListController::class, 'getLists'])->name('get.lists');
    Route::get('/list/copy/{id}', [ListController::class, 'copy'])->name('list.copy');
    Route::any('/list_split/{id?}', [ListController::class, 'split'])->name('list.split');
    Route::post('/list_empty/{id}', [ListController::class, 'empty'])->name('list.empty');
    Route::any('/list/bulk_update', [ListController::class, 'bulkUpdate'])->name('bulk.update');

    // Groups
    Route::resource('groups', GroupController::class)->except(['show']);
    Route::get('/group_create/{type_id?}', [GroupController::class, 'create'])->name('group.create');
    Route::get('/get_group_lists/{type_id?}', [GroupController::class, 'getGroupLists'])->name('get.group.lists');
    Route::delete('/group-delete/{model}', [GroupController::class, 'deleteGroup'])->name('group.delete');


    // Custom Fields
    Route::resource('custom_fields', CustomFieldController::class)->except(['show']);
    Route::get('/get_custom_fields', [CustomFieldController::class, 'getCustomFields'])->name('get.custom_fields');
    Route::get('/custom_field_create', [CustomFieldController::class, 'create'])->name('custom_field.create');


    // Contacts
    Route::resource('contacts', ContactController::class);
    Route::get('/get_contacts', [ContactController::class, 'getContacts'])->name('get.contacts');
    Route::get('/lists-custom-fields', [ContactController::class, 'getListsCustomFields'])->name('list.custom_fields');
    Route::any('/contacts-export/{id}/{data?}', [ContactController::class, 'contactsExport'])->name('contacts.export');
    Route::any('/contacts-import/{id?}', [ContactController::class, 'contactsImport'])->name('contacts.import');
    Route::get('/contacts-import-status/{id}', [ContactController::class, 'contactsImportStatus']);
    Route::any('/contacts-customize-listing', [ContactController::class, 'contactsCustomizeListing'])->name('contacts.customize.listing');


    // Suppression
    Route::resource('suppressions', SuppressionController::class)->except(['show','edit', 'update']);
    Route::get('/get_suppression', [SuppressionController::class, 'getSuppressions'])->name('get.suppressions');
    Route::post('/suppression/import', [SuppressionController::class, 'suppressionImport'])->name('suppression.import');
    Route::get('/suppression/export', [SuppressionController::class, 'suppressionExport'])->name('suppression.export');

    // Notifications
    Route::get('/notification/read/{id}', [NotificationController::class, 'read'])->name('notification.read');
    Route::get('/notification/read_all', [NotificationController::class, 'readAll'])->name('notification.read.all');

    // Broadcasts
    Route::resource('broadcasts', BroadcastController::class);
    Route::get('/get_broadcasts', [BroadcastController::class, 'getBroadcasts'])->name('broadcasts');
    Route::get('/broadcast/copy/{id}', [BroadcastController::class, 'copy'])->name('broadcast.copy');
    Route::any('/broadcast/mail-headers',  [BroadcastController::class, 'mailHeaders'])->name('broadcast.mail.headers');
    Route::get('/broadcast/detail/{id}',  [BroadcastController::class, 'getBoradcastDetail'])->name('broadcast.detail');
    Route::get('/broadcasts-all', function() {
        return view('broadcasts.all');
    })->name('broadcasts.all');
    Route::get('/broadcast/html/{id}', [BroadcastController::class, 'getHTMLContent']);
    Route::post('/check_spam_score', [BroadcastController::class, 'checkSpamScore'])->name('check.spam.score');

    // Templates
    Route::resource('templates', TemplateController::class)->except(['update']);
    Route::get('/get_templates', [TemplateController::class, 'getTemplates'])->name('get.templates');
    Route::get('/template/select', [TemplateController::class, 'templateSelect'])->name('template.select');
    Route::get('/get_builder', [TemplateController::class, 'getBuilder'])->name('get.builder');
    Route::get('/get_rz_builder', [TemplateController::class, 'getRZBuilder'])->name('get.rz_builder');
    Route::post('/template_save', [TemplateController::class, 'store'])->name('template.save');
    Route::get('/template/html/{id}', [TemplateController::class, 'getHTMLContent']);
    Route::get('/templates-all', function() {
        return view('templates.all');
    })->name('templates.all');

    // Spintag
    Route::resource('spintags', SpintagController::class)->except(['show']);;
    Route::get('/get_spintags', [SpintagController::class, 'getSpintags'])->name('get.spintags');

    // Reply Servers
    Route::resource('reply_servers', ReplyServerController::class)->except(['show']);
    Route::get('/get_reply_servers', [ReplyServerController::class, 'getReplyServers'])->name('get.reply_servers');
    Route::get('/validate_reply_server_imap', [ReplyServerController::class, 'validateImap'])->name('validateReplyServerImap');
    Route::get('/reply_server/copy/{id}', [ReplyServerController::class, 'copy'])->name('reply_server.copy');
    Route::get('/reply/html/{id}', [ReplyServerController::class, 'getReplyHTML'])->name('get.reply_html');

    // Bounce Servers
    Route::resource('bounces', BounceController::class)->except(['show']);
    Route::get('/get_bounces', [BounceController::class, 'getBounces'])->name('get.bounces');
    Route::get('/validate_bounce_imap', [BounceController::class, 'validateImap'])->name('validateBounceImap');
    Route::get('/bounce/copy/{id}', [BounceController::class, 'copy'])->name('bounce.copy');

    // Feedback Loop Servers
    Route::resource('fbls', FblController::class)->except(['show']);
    Route::get('/get_fbls', [FblController::class, 'getfbls'])->name('get.fbls');
    Route::get('/validate_fbl_imap', [FblController::class, 'validateImap'])->name('validateFblImap');
    Route::get('/fbl/copy/{id}', [FblController::class, 'copy'])->name('fbl.copy');

    // Sending Domains
    Route::resource('sending_domains', SendingDomainController::class)->except(['edit']);
    Route::get('/get_sending_domains', [SendingDomainController::class, 'getSendingDomains'])->name('get.sending_domains');
    Route::get('/download_keys/{id}', [SendingDomainController::class, 'downloadKeys'])->name('download.keys');
    Route::get('/domain_verfications/{id}/{type}', [SendingDomainController::class, 'domainVerifications'])->name('domain.verifications');
    Route::put('/sending_domain/status', [SendingDomainController::class, 'setStatus'])->name('sending_domains.set_status');

    // Tracking Domains
    Route::resource('tracking_domains', TrackingDomainController::class)->except(['show']);
    Route::get('/get_tracking_domains', [TrackingDomainController::class, 'getTrackingDomains'])->name('get.tracking_domains');

    // EmailsPages
    Route::resource('contents', EmailPageController::class);
    Route::get('/get_emails_pages', [EmailPageController::class, 'getEmailsPages'])->name('get.emails_pages');

    // Sending Servers
    Route::resource('sending_servers', SendingServerController::class);
    Route::get('/get_sending_servers', [SendingServerController::class, 'getSendingServers'])->name('get.sending_servers');
    Route::get('/get_sending_server_fields/{type}/{action}/{id?}', [SendingServerController::class, 'getSendingServerFields']);
    Route::get('/sending_server/copy/{id}', [SendingServerController::class, 'copy'])->name('sending_server.copy');
    Route::put('/sending_server/reset_counter/{id}', [SendingServerController::class, 'resetCounter'])->name('sent.clear');
    Route::put('/sending_server/status', [SendingServerController::class, 'setStatus'])->name('sending_servers.set_status');

    Route::get('/sending_server/status/{id}', function($id){
        return view('sending_servers.status')->with('id', $id);
    })->name('sending_server.status');
    Route::get('/callback_help/{type}', function($type){
        return view('sending_servers.callback_help')->with('type', $type);
    })->name('callback.help');
    Route::get('/send_email/{broadcast_id}/{sending_server_id}/{template_id}/{display_name?}', function($broadcast_id, $sending_server_id, $template_id, $display_name=null){
        return view('includes.send_test_email')->with(compact('broadcast_id', 'sending_server_id', 'template_id', 'display_name'));
    })->name('send.email');
    Route::post('/send_email_test', [SendingServerController::class, 'sendEmailTest']);

    // get shortcodes
    Route::get('/shortcodes/{section?}', function($section='all'){
        return \App\Http\Helper\Helper::shortcodes($section);
    })->name('shortcodes');

    // schedules campaigns
    Route::resource('schedule_campaigns', ScheduleCampaignController::class);
    Route::get('/get_schedule_campaigns', [ScheduleCampaignController::class, 'getScheduleCampaigns'])->name('get.schedule_campaigns');
    Route::post('/schedule_campaigns/{id}/stop_auto_scheduled', [ScheduleCampaignController::class, 'stopAutoScheduled'])->name('schedule_campaigns.stop_auto_scheduled');
    Route::get('/get_scheduled_detail_stat_campaign/{id}/{type?}', [ScheduleCampaignController::class, 'getScheduledDetail'])->name('scheduled.detail.campaign');
    Route::get('/copy_schedule/{id}', [ScheduleCampaignController::class, 'copy'])->name('copy.schedule');
    Route::get('/schedule_campaign/html/{id}', [ScheduleCampaignController::class, 'getHTMLContent'])->name('get.schedule_campaign.content');
    Route::put('/limited_to_unlimited', [ScheduleCampaignController::class, 'limitedToUnlimited'])->name('limited.to.unlimited');
    Route::put('/set_2x_speed', [ScheduleCampaignController::class, 'set2xSpeed'])->name('set.2x.speed');
    Route::put('/update_schedule_campaign_status/{id}', [ScheduleCampaignController::class, 'updateScheduleStatus']);
    Route::get('/shceduled_events', [ScheduleCampaignController::class, 'scheduledEvents']);

    Route::get('/download-attachment/{schedule_id}/{user_id}/{file}', [ScheduleCampaignController::class, 'downloadAttachment'])
    ->name('download.attachment');
    Route::delete('/delete-attachment/{schedule_id}', [ScheduleCampaignController::class, 'deleteAttachment'])
    ->name('delete.attachment');


    // Analatics Campaigns
    Route::get('/stats/campaigns', [ScheduleCampaignStatController::class, 'index'])->name('stats.campaigns.index');
    Route::get('/get_stats_campaigns', [ScheduleCampaignStatController::class, 'getStatsCampaigns'])->name('stats.campaigns');
    Route::get('/stat/export/{id}', [ScheduleCampaignStatController::class, 'export'])->name('stat.campaign.export');
    Route::get('/stat/aiAnalysis/{id}', [ScheduleCampaignStatController::class, 'aiAnalysis'])->name('stat.campaign.ai.analysis');
    Route::get('/stat/export/download/{id}', [ScheduleCampaignStatController::class, 'exportDownload'])->name('stat.campaign.export.download');
    Route::get('/detail/stat/campaign/{id?}/{type?}/{view?}', [ScheduleCampaignStatController::class, 'getDetailStat'])->name('detail.stat.campaign');
    Route::get('/campaign/opens', [ScheduleCampaignStatController::class, 'getOpens'])->name('campaign.opens');
    Route::get('/campaign/clicks', [ScheduleCampaignStatController::class, 'getClicks'])->name('campaign.clicks');
    Route::get('/campaign/unsubscribed', [ScheduleCampaignStatController::class, 'getUnsubscribed'])->name('campaign.unsubscribed');
    Route::get('/campaign/bounces', [ScheduleCampaignStatController::class, 'getBounces'])->name('campaign.bounces');
    Route::get('/campaign/spam', [ScheduleCampaignStatController::class, 'getSpam'])->name('campaign.spam');
    Route::get('/campaign/replies', [ScheduleCampaignStatController::class, 'getReplies'])->name('campaign.replies');
    Route::get('/campaign/logs', [ScheduleCampaignStatController::class, 'getLogs'])->name('campaign.logs');
    Route::get('/campaign/sent/{id}/{type?}', [ScheduleCampaignStatController::class, 'getSentData'])->name('campaign.sent.data');
    Route::delete('/stat/destroy/{id}/{name}', [ScheduleCampaignStatController::class, 'destroy'])->name('stat.campaign.destroy');

    // Blacklist Controller
    Route::get('/system_bounced', [BlacklistController::class, 'systemBounced'])->name('system.bounced');
    Route::get('/get_system_bounced', [BlacklistController::class, 'getSystemBounced'])->name('get.system.bounced');
    Route::delete('/system_bounced/{id}', [BlacklistController::class, 'destroySystemBounced'])->name('system.bounced.destroy');
    Route::any('/global/bounced/import', [BlacklistController::class, 'importSystemBounced'])->name('system.bounced.import');
    Route::get('/global/bounced/export', [BlacklistController::class, 'exportBounced'])->name('system.bounced.export');

    // Segmentation
    Route::resource('list_segmentations', SegmentationController::class);
    Route::get('get_list_campaign_segmentations', [SegmentationController::class, 'getSegmentations'])->name('get.list.campaign.segmentations');
    Route::get('/segment/action/{id}/{action}', [SegmentationController::class, 'action'])->name('segment.action');
    Route::put('/segment/action/{id}', [SegmentationController::class, 'action'])->name('segment.update.action');

    Route::get('campaign_segmentations', [SegmentationController::class, 'indexCampaign'])->name('campaign_segmentations.index');


    // Clients Controller
    Route::resource('clients', ClientController::class);
    Route::get('/get_clients', [ClientController::class, 'getClients'])->name('get.clients');

    // Packages Controller
    Route::resource('packages', PackageController::class)->except(['show']);
    Route::get('/get_packages', [PackageController::class, 'getPackages'])->name('get.packages');

    // Trigger Controller
    Route::resource('triggers', TriggerController::class)->except(['show']);
    Route::get('/get_triggers', [TriggerController::class, 'getTriggers'])->name('get.triggers');
    Route::get('/get_based_on_data/{type}/{action}/{id?}', [TriggerController::class, 'getBasedOnData']);

    // Analatics Triggers
    Route::get('/stats/triggers', [TriggerScheduleStatController::class, 'index'])->name('stats.triggers.index');
    Route::get('/get_stats_triggers', [TriggerScheduleStatController::class, 'getStatsTriggers'])->name('stats.triggers');
    Route::get('/stat/trigger/export/{id}', [TriggerScheduleStatController::class, 'export'])->name('stat.trigger.export');
    Route::get('/stat/trigger/export/download/{id}', [TriggerScheduleStatController::class, 'exportDownload'])->name('stat.trigger.export.download');
    Route::get('/detail/stat/trigger/{id?}/{type?}/{view?}', [TriggerScheduleStatController::class, 'getDetailStat'])->name('detail.stat.trigger');
    Route::get('/trigger/opens', [TriggerScheduleStatController::class, 'getOpens'])->name('trigger.opens');
    Route::get('/trigger/clicks', [TriggerScheduleStatController::class, 'getClicks'])->name('trigger.clicks');
    Route::get('/trigger/unsubscribed', [TriggerScheduleStatController::class, 'getUnsubscribed'])->name('trigger.unsubscribed');
    Route::get('/trigger/bounces', [TriggerScheduleStatController::class, 'getBounces'])->name('trigger.bounces');
    Route::get('/trigger/replies', [TriggerScheduleStatController::class, 'getReplies'])->name('trigger.replies');
    Route::get('/trigger/spam', [TriggerScheduleStatController::class, 'getSpam'])->name('trigger.spam');
    Route::get('/trigger/logs', [TriggerScheduleStatController::class, 'getLogs'])->name('trigger.logs');
    Route::get('/trigger/sent/{id}/{type?}', [TriggerScheduleStatController::class, 'getSentData'])->name('trigger.sent.data');
    Route::delete('/stat/trigger/destroy/{id}/{name}', [TriggerScheduleStatController::class, 'destroy'])->name('stat.trigger.destroy');
    Route::get('/trigger/html/{id}', [TriggerScheduleStatController::class, 'getHTMLContent'])->name('get.trigger_schedule.content');


    // Drips
    Route::resource('drips', DripController::class);
    Route::get('/get_drips', [DripController::class, 'getDrips'])->name('get.drips');
    Route::get('/drip/campaign/{id}', [DripController::class, 'show'])->name('drip.campaign.show');
    Route::get('/detail/stat/drip/{id}/{type?}/{view?}', [DripScheduleStatController::class, 'getDetailStat'])->name('detail.stat.drip');
    Route::get('/drip/sent/{id}/{type?}', [DripScheduleStatController::class, 'getSentData'])->name('drip.sent.data');
    Route::get('/drip/opens', [DripScheduleStatController::class, 'getOpens'])->name('drip.opens');
    Route::get('/drip/clicks', [DripScheduleStatController::class, 'getClicks'])->name('drip.clicks');
    Route::get('/drip/unsubscribed', [DripScheduleStatController::class, 'getUnsubscribed'])->name('drip.unsubscribed');
    Route::get('/drip/bounces', [DripScheduleStatController::class, 'getBounces'])->name('drip.bounces');
    Route::get('/drip/spam', [DripScheduleStatController::class, 'getSpam'])->name('drip.spam');
    Route::get('/drip/replies', [DripScheduleStatController::class, 'getReplies'])->name('drip.replies');
    Route::get('/drip/logs', [DripScheduleStatController::class, 'getLogs'])->name('drip.logs');
    Route::get('/stat/drip/export/{id}', [DripScheduleStatController::class, 'export'])->name('stat.drip.export');
    Route::get('/stat/drip/export/download/{id}', [DripScheduleStatController::class, 'exportDownload'])->name('stat.drip.export.download');

    // Split Tests
    Route::resource('split_tests', SplitTestController::class);
    Route::get('/get_split_tests', [SplitTestController::class, 'getSplitTests'])->name('get.split_tests');
    Route::put('/update_split_test_status/{id}', [SplitTestController::class, 'updateSplitTestStatus']);
    Route::put('/limited_to_unlimited_split_test', [SplitTestController::class, 'limitedToUnlimited'])->name('limited.to.unlimited.splittest');
    Route::put('/set_2x_speed_split_test', [SplitTestController::class, 'set2xSpeed'])->name('set.2x.speed.splittet');
    Route::get('/detail/stat/split_test/{id}/{type?}/{view?}', [SplitTestStatController::class, 'getDetailStat'])->name('detail.stat.split_test');

    Route::get('/stats/split_tests', [SplitTestStatController::class, 'index'])->name('stats.split_tests.index');
    Route::get('/get_stats_split_tests', [SplitTestStatController::class, 'getSplitTests'])->name('stats.split_tests');
    Route::get('/stat/split_test/export/{id}', [SplitTestStatController::class, 'export'])->name('stat.split_test.export');
    Route::get('/stat/split_test/export/download/{id}', [SplitTestStatController::class, 'exportDownload'])->name('stat.split_test.export.download');
    Route::get('/split_test/sent/{id}/{type?}', [SplitTestStatController::class, 'getSentData'])->name('split_test.sent.data');
    Route::get('/split_test/opens', [SplitTestStatController::class, 'getOpens'])->name('split_test.opens');
    Route::get('/split_test/clicks', [SplitTestStatController::class, 'getClicks'])->name('split_test.clicks');
    Route::get('/split_test/unsubscribed', [SplitTestStatController::class, 'getUnsubscribed'])->name('split_test.unsubscribed');
    Route::get('/split_test/bounces', [SplitTestStatController::class, 'getBounces'])->name('split_test.bounces');
    Route::get('/split_test/spam', [SplitTestStatController::class, 'getSpam'])->name('split_test.spam');
    Route::get('/split_test/replies', [SplitTestStatController::class, 'getReplies'])->name('split_test.replies');
    Route::get('/split_test/logs', [SplitTestStatController::class, 'getLogs'])->name('split_test.logs');
    Route::delete('/stat/splittest/destroy/{id}/{name}', [SplitTestStatController::class, 'destroy'])->name('stat.splittest.destroy');

    // WebFroms
    Route::resource('webforms', WebformController::class)->except(['show']);
    Route::get('/get_webforms', [WebformController::class, 'getWebforms'])->name('get.webforms');
    Route::get('/webforms/{id}/{get_html?}', [WebformController::class, 'show'])->name('webforms.show');
    Route::get('/webform/copy/{id}', [WebformController::class, 'copy'])->name('webform.copy');


    // Email Health
    Route::get('/blacklisted_ips', [BlacklistController::class, 'blacklistedIPs'])->name('blacklisted.ips');
    Route::get('/get_blacklisted_ips', [BlacklistController::class, 'getblacklistedIPs'])->name('get.blacklisted.ips');
    Route::get('/blacklisted_domains', [BlacklistController::class, 'blacklistedDomains'])->name('blacklisted.domains');
    Route::get('/get_blacklisted_domains', [BlacklistController::class, 'getblacklistedDomains'])->name('get.blacklisted.domains');
    Route::get('/blacklisted_detail/{id}', [BlacklistController::class, 'blacklistedDetail'])->name('blacklisted.detail');

    // Email Verifier
    Route::resource('email_verifiers', EmailVerifierController::class);
    Route::get('/get_email_verifiers', [EmailVerifierController::class, 'getEmailVerifiers'])->name('get.email_verifiers');
    Route::get('/get_email_verifiers_fields/{type}/{action}/{id?}', [EmailVerifierController::class, 'getEmailVerifiersFields']);
    Route::any('/verify_email/{id?}/{email?}', [EmailVerifierController::class, 'verifyEmail'])->name('verify.email');
    Route::any('/verify_email_list/{id?}/{list_id?}', [EmailVerifierController::class, 'verifyEmailList'])->name('verify.email.list');

    // Warmup Plan
    Route::resource('warmup_plans', WarmupPlanController::class)->except(['edit']);
    Route::get('/get_warmup_plans', [WarmupPlanController::class, 'getWarmupPlans'])->name('get.warmup_plans');

    // Note
    Route::resource('notes', NoteController::class);
    Route::put('note/pin/{id}', [NoteController::class, 'pin'])->name('note.pin');

    // Language
    Route::get('/language/{lang}', [UserController::class, 'changeLang'])->name('lang');


    // PowerMTA
    Route::get('pmta', [PmtaController::class, 'index'])->name('pmta.index');
    Route::get('/get_pmtas', [PmtaController::class, 'getPmtas'])->name('get.pmtas');
    Route::get('/pmta_data/{id?}', [PmtaController::class, 'createEdit'])->name('pmta.create.edit');
    Route::delete('/destroy/{id}', [PmtaController::class, 'destroy'])->name('pmta.destroy');
    Route::post('pmta_steps/{step?}/{id?}', [PmtaController::class, 'pmtaSteps']);
    Route::get('/download/pmta/{name}', [PmtaController::class, 'download'])->name('download.pmta');

    Route::get('/pmta_create_bounce', [PmtaController::class, 'createBouncePMTA'])->name('pmta.create.bounce');
    Route::post('/pmta_save_bounce', [PmtaController::class, 'saveBouncePMTA'])->name('pmta.save.bounce');
    Route::get('/pmta_edit_bounce/{id}', [PmtaController::class, 'editBouncePMTA'])->name('pmta.edit.bounce');
    Route::put('/pmta_update_bounce', [PmtaController::class, 'updateBouncePMTA'])->name('pmta.update.bounce');

    // pmta server operatoins
    Route::get('/server/{operation}/{id}', [PmtaController::class, 'restart']);

    // ChatGPT
    Route::any('/chatGPT_settings', [SettingController::class, 'chatGPTSettings'])->name('chatGPT.settings');
    Route::post('/chatGPT', [SettingController::class, 'chatGPT'])->name('chatGPT');

    // General
    Route::any('/general_settings', [SettingController::class, 'generalSettings'])->name('general.settings');


});

// No authenticate
Route::group(['middleware' => ['language']], function() {
    Route::get('/run_campaigns/{id?}/{thread_no?}', [ScheduleCampaignController::class, 'runCampaigns']);
    Route::get('/contact/unsub/{contact_id}/{stat_log_id?}/{type?}', [ContactController::class, 'unsub'])->name('contact.unsub');
    Route::get('/contact/do-unsub/{id}/{stat_log_id?}/{type?}', [ContactController::class, 'doUnsub'])->name('contact.do.unsub');
    Route::get('/page/{slug}/{contact_id?}/{stat_log_id?}/{type?}', [EmailPageController::class, 'showPage'])->name('page.show');
    Route::get('/process_split_test/{id?}/{thread_no?}', [SplitTestController::class, 'processSplitTest']);
    Route::any('/webform_save_data', [WebformController::class, 'saveWebFormData'])->name('webform.save.data');
});

// No middleware
Route::get('/ok', function(){
  return response()->json(['success' => 'success'], 200);
});


// Campaign
Route::get('/open/{id}', [TrackingController::class, 'openSchedule']);
Route::get('/click/{id}/{url}', [TrackingController::class, 'clickSchedule']);

// Triggers
Route::get('/ts/open/{id}', [TrackingController::class, 'openTriggerSchedule']);
Route::get('/ts/click/{id}/{url}', [TrackingController::class, 'clickTriggerSchedule']);

// Drips
Route::get('/d/open/{id}', [TrackingController::class, 'openDripSchedule']);
Route::get('/d/click/{id}/{url}', [TrackingController::class, 'clickDripSchedule']);

// Split Test
Route::get('/st/open/{id}', [TrackingController::class, 'openSplitTest']);
Route::get('/st/click/{id}/{url}', [TrackingController::class, 'clickSplitTest']);

// Installation
Route::post('/installation', [InstallController::class, 'installation']);


// Callbacks
Route::prefix('callback')->group(function () {
  // any to return success
  Route::any('amazon', [CallbackController::class, 'amazon']);
  Route::any('mailgun', [CallbackController::class, 'mailgun']);
  Route::any('sendgrid', [CallbackController::class, 'sendgrid']);
  Route::any('sparkpost', [CallbackController::class, 'sparkpost']);
  Route::any('elasticemail', [CallbackController::class, 'elasticEmail']);
  Route::any('postal', [CallbackController::class, 'postal']);
});


// check curl request working proprely
Route::get('/ger_curl_version', function(){
    echo \App\Http\Helper\Helper::getUrl(config('custom.version_live_url'));
})->name('ger_curl_version');

